/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.statistics.distribution.StudentizedRangeDistribution;
import gov.sandia.cognition.statistics.method.AbstractMultipleHypothesisComparison;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

@ConfidenceTestAssumptions(name="Tukey-Kramer Range test", alsoKnownAs={"Tukey's Range test", "Tukey's Honestly Significant Difference test", "Tukey's HSD test"}, description={"Tukey's test determines which treatment is statistically different from a multiple comparison.", "Tukey's test is a generalization of the paired Student's t-test for multiple comparisons using a population-correction factor."}, assumptions={"All data came from same distribution, without considering treatment effects.", "The observations have equal variance.", "Measurements are independent and equivalent within a treatment.", "All observations are independent."}, nullHypothesis="Each treatment has no effect on the mean outcome of the subjects", dataPaired=false, dataSameSize=false, distribution=StudentizedRangeDistribution.class, reference={@PublicationReference(author={"Wikipedia"}, title="Tukey's range test", type=PublicationType.WebPage, year=2011, url="http://en.wikipedia.org/wiki/Tukey's_range_test")})
public class TukeyKramerConfidence
extends AbstractMultipleHypothesisComparison<Collection<? extends Number>, Statistic> {
    public TukeyKramerConfidence clone() {
        return (TukeyKramerConfidence)super.clone();
    }

    @Override
    public Statistic evaluateNullHypotheses(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha) {
        int K = data.size();
        ArrayList<Integer> subjectCounts = new ArrayList<Integer>(K);
        ArrayList<Double> treatmentMeans = new ArrayList<Double>(K);
        LinkedList<? extends Number> allData = new LinkedList<Number>();
        for (Collection<? extends Number> collection : data) {
            int Ni = collection.size();
            subjectCounts.add(Ni);
            treatmentMeans.add(UnivariateStatisticsUtil.computeMean(collection));
            allData.addAll(collection);
        }
        Pair result = UnivariateStatisticsUtil.computeMeanAndVariance(allData);
        double d = (Double)result.getSecond();
        return new Statistic(uncompensatedAlpha, subjectCounts, treatmentMeans, d);
    }

    public static class Statistic
    extends AbstractMultipleHypothesisComparison.Statistic {
        protected ArrayList<Integer> subjectCounts;
        protected ArrayList<Double> treatmentMeans;
        protected double totalVariance;
        protected Matrix standardErrors;

        public Statistic(double uncompensatedAlpha, ArrayList<Integer> subjectCounts, ArrayList<Double> treatmentMeans, double totalVariance) {
            this.treatmentCount = treatmentMeans.size();
            this.uncompensatedAlpha = uncompensatedAlpha;
            this.subjectCounts = subjectCounts;
            this.treatmentMeans = treatmentMeans;
            this.totalVariance = totalVariance;
            this.testStatistics = this.computeTestStatistics(subjectCounts, treatmentMeans, totalVariance);
            this.nullHypothesisProbabilities = this.computeNullHypothesisProbabilities(subjectCounts, this.testStatistics);
        }

        public Matrix computeTestStatistics(ArrayList<Integer> subjectCounts, ArrayList<Double> treatmentMeans, double totalVariance) {
            int K = treatmentMeans.size();
            Matrix Z = MatrixFactory.getDefault().createMatrix(K, K);
            this.standardErrors = MatrixFactory.getDefault().createMatrix(K, K);
            for (int i = 0; i < K; ++i) {
                double yi = treatmentMeans.get(i);
                int ni = subjectCounts.get(i);
                for (int j = i + 1; j < K; ++j) {
                    int nj = subjectCounts.get(j);
                    double yj = treatmentMeans.get(j);
                    double standardError = Math.sqrt(totalVariance * 0.5 * (1.0 / (double)ni + 1.0 / (double)nj));
                    double zij = Math.abs(yi - yj) / standardError;
                    Z.setElement(i, j, zij);
                    Z.setElement(j, i, zij);
                    this.standardErrors.setElement(i, j, standardError);
                    this.standardErrors.setElement(j, i, standardError);
                }
            }
            return Z;
        }

        protected Matrix computeNullHypothesisProbabilities(ArrayList<Integer> subjectCounts, Matrix Z) {
            int K = Z.getNumRows();
            double N = UnivariateStatisticsUtil.computeSum(subjectCounts);
            Matrix P = MatrixFactory.getDefault().createMatrix(K, K);
            StudentizedRangeDistribution.CDF cdf = new StudentizedRangeDistribution.CDF(K, N - 1.0);
            for (int i = 0; i < K; ++i) {
                P.setElement(i, i, 1.0);
                for (int j = i + 1; j < K; ++j) {
                    double zij = Z.getElement(i, j);
                    double pij = 1.0 - cdf.evaluate(zij * Math.sqrt(2.0));
                    P.setElement(i, j, pij);
                    P.setElement(j, i, pij);
                }
            }
            return P;
        }

        @Override
        public Statistic clone() {
            Statistic clone = (Statistic)super.clone();
            clone.treatmentMeans = ObjectUtil.cloneSmartElementsAsArrayList(this.getTreatmentMeans());
            clone.subjectCounts = ObjectUtil.cloneSmartElementsAsArrayList(this.getSubjectCounts());
            return clone;
        }

        public ArrayList<Integer> getSubjectCounts() {
            return this.subjectCounts;
        }

        public ArrayList<Double> getTreatmentMeans() {
            return this.treatmentMeans;
        }

        public double getTotalVariance() {
            return this.totalVariance;
        }

        @Override
        public boolean acceptNullHypothesis(int i, int j) {
            return this.getNullHypothesisProbability(i, j) >= this.getUncompensatedAlpha();
        }

        public Matrix getStandardErrors() {
            return this.standardErrors;
        }
    }
}

