/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.statistics.method.AbstractPairwiseMultipleHypothesisComparison;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.statistics.method.SidakCorrection;
import gov.sandia.cognition.util.ArrayIndexSorter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

@PublicationReferences(references={@PublicationReference(author={"Juliet Popper Shaffer"}, title="Modified Sequentially Rejective Multiple Test Procedures", type=PublicationType.Journal, publication="Journal of the American Statistical Association", year=1986, url="http://www.jstor.org/stable/2289016"), @PublicationReference(author={"Juliet Popper Shaffer"}, title="Multiple Hypothesis Testing", type=PublicationType.Journal, publication="Annual Review of Psychology", year=1995, url="http://www.dm.uba.ar/materias/optativas/aspectos_estadisticos_de_microarreglos/2010/1/teoricas/Shaffer%201995%20Multiple%20hypothesis%20testing.pdf"), @PublicationReference(author={"Salvador Garcia", "Francisco Herrera"}, title="An Extension on \"Statistical Comparisons of Classi\ufb01ers over Multiple Data Sets\" for all Pairwise Comparisons", type=PublicationType.Journal, publication="Journal of Machine Learning Research", year=2008, url="http://sci2s.ugr.es/publications/ficheros/2008-Garcia-JMLR.pdf")})
public class ShafferStaticCorrection
extends AbstractPairwiseMultipleHypothesisComparison<Statistic> {
    public ShafferStaticCorrection() {
        this(DEFAULT_PAIRWISE_TEST);
    }

    public ShafferStaticCorrection(NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
        super(pairwiseTest);
    }

    @Override
    public ShafferStaticCorrection clone() {
        return (ShafferStaticCorrection)super.clone();
    }

    @Override
    public Statistic evaluateNullHypotheses(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha) {
        return new Statistic(data, uncompensatedAlpha, this.getPairwiseTest());
    }

    public static class Statistic
    extends AbstractPairwiseMultipleHypothesisComparison.Statistic {
        protected Matrix adjustedAlphas;

        public Statistic(Collection<? extends Collection<? extends Number>> data, double uncompensatedAlpha, NullHypothesisEvaluator<Collection<? extends Number>> pairwiseTest) {
            super(data, uncompensatedAlpha, pairwiseTest);
            int numComparisons = this.treatmentCount * (this.treatmentCount - 1) / 2;
            this.computePairwiseTestResults(data, pairwiseTest);
            ArrayList<Integer> possibleTruths = Statistic.possibleTruthsSorted(this.treatmentCount);
            double[] pvalues = new double[numComparisons];
            int index = 0;
            for (int i = 0; i < this.treatmentCount; ++i) {
                for (int j = i + 1; j < this.treatmentCount; ++j) {
                    pvalues[index] = this.nullHypothesisProbabilities.getElement(i, j);
                    ++index;
                }
            }
            int[] sortedIndices = ArrayIndexSorter.sortArrayAscending((double[])pvalues);
            double[] adjustedAlpha = new double[numComparisons];
            int maxPossibleTruthIndex = possibleTruths.size() - 1;
            int hypothesesRemaining = numComparisons;
            for (int i = 0; i < numComparisons; ++i) {
                int maxPossibleTrueHypotheses = possibleTruths.get(maxPossibleTruthIndex);
                adjustedAlpha[sortedIndices[i]] = SidakCorrection.adjust(this.uncompensatedAlpha, maxPossibleTrueHypotheses);
                if (pvalues[sortedIndices[i]] >= adjustedAlpha[sortedIndices[i]]) break;
                if (--hypothesesRemaining >= maxPossibleTrueHypotheses) continue;
                --maxPossibleTruthIndex;
            }
            Matrix alphaMatrix = MatrixFactory.getDefault().createMatrix(this.treatmentCount, this.treatmentCount);
            index = 0;
            for (int i = 0; i < this.treatmentCount; ++i) {
                for (int j = i + 1; j < this.treatmentCount; ++j) {
                    alphaMatrix.setElement(i, j, adjustedAlpha[index]);
                    alphaMatrix.setElement(j, i, adjustedAlpha[index]);
                    ++index;
                }
            }
            this.adjustedAlphas = alphaMatrix;
        }

        public static ArrayList<Integer> possibleTruthsSorted(int treatmentCount) {
            int[] jchoose2 = new int[treatmentCount + 1];
            for (int j = 2; j <= treatmentCount; ++j) {
                jchoose2[j] = (int)Math.round(Math.exp(MathUtil.logBinomialCoefficient((int)j, (int)2)));
            }
            ArrayList<LinkedHashSet<Integer>> recusionCaches = new ArrayList<LinkedHashSet<Integer>>(treatmentCount);
            for (int j = 0; j < treatmentCount; ++j) {
                recusionCaches.add(null);
            }
            LinkedHashSet<Integer> set = Statistic.possibleTruthsSet(treatmentCount, jchoose2, recusionCaches);
            ArrayList sortedSet = CollectionUtil.asArrayList(set);
            Collections.sort(sortedSet);
            return sortedSet;
        }

        private static LinkedHashSet<Integer> possibleTruthsSet(int treatmentCount, int[] jchoose2, ArrayList<LinkedHashSet<Integer>> recursionCaches) {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>(treatmentCount);
            if (treatmentCount <= 1) {
                set.add(0);
            } else if (treatmentCount == 2) {
                set.add(1);
            } else {
                for (int j = 1; j <= treatmentCount; ++j) {
                    int tcmj = treatmentCount - j;
                    LinkedHashSet<Integer> recursion = recursionCaches.get(tcmj);
                    if (recursion == null) {
                        recursion = Statistic.possibleTruthsSet(tcmj, jchoose2, recursionCaches);
                        recursionCaches.set(tcmj, recursion);
                    }
                    for (Integer value : recursion) {
                        int choose = j < 2 ? 0 : jchoose2[j];
                        set.add(value + choose);
                    }
                }
            }
            return set;
        }

        @Override
        public double getAdjustedAlpha(int i, int j) {
            return this.adjustedAlphas.getElement(i, j);
        }
    }
}

