/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.distribution.BinomialDistribution;
import gov.sandia.cognition.statistics.method.AbstractConfidenceStatistic;
import gov.sandia.cognition.statistics.method.ConfidenceTestAssumptions;
import gov.sandia.cognition.statistics.method.NullHypothesisEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;
import java.util.Iterator;

@ConfidenceTestAssumptions(name="Fisher Sign Test", alsoKnownAs={"Sign Test"}, description={"Determines if there is a statistically significant between the means of two groups", "A robust nonparameteric alternative to the paired Student's t-test."}, assumptions={"The data from each group is sampled independently of each other."}, nullHypothesis="The means of the two groups is the same.", dataPaired=true, dataSameSize=true, distribution=BinomialDistribution.CDF.class, reference={@PublicationReference(author={"Eric W. Weisstein"}, title="Fisher Sign Test", type=PublicationType.WebPage, year=2009, url="http://mathworld.wolfram.com/FisherSignTest.html")})
public class FisherSignConfidence
extends AbstractCloneableSerializable
implements NullHypothesisEvaluator<Collection<? extends Number>> {
    public Statistic evaluateNullHypothesis(Collection<? extends Number> data1, Collection<? extends Number> data2) {
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("data1 and data2 must have same number of elements.");
        }
        int N = 0;
        int b = 0;
        Iterator<? extends Number> i1 = data1.iterator();
        Iterator<? extends Number> i2 = data2.iterator();
        while (i1.hasNext()) {
            double v2;
            double v1 = i1.next().doubleValue();
            if (v1 != (v2 = i2.next().doubleValue())) {
                ++N;
            }
            if (!(v1 > v2)) continue;
            ++b;
        }
        return new Statistic(b, N);
    }

    public static class Statistic
    extends AbstractConfidenceStatistic {
        private int numDifferent;
        private int numPositiveSign;

        public Statistic(int numPositiveSign, int numDifferent) {
            super(2.0 * Math.min(BinomialDistribution.CDF.evaluate(numDifferent, numPositiveSign, 0.5), 1.0 - BinomialDistribution.CDF.evaluate(numDifferent, numPositiveSign, 0.5)));
            if (numPositiveSign > numDifferent) {
                throw new IllegalArgumentException("numPositiveSign must be <= numDifferent");
            }
            this.setNumPositiveSign(numPositiveSign);
            this.setNumDifferent(numDifferent);
        }

        public int getNumDifferent() {
            return this.numDifferent;
        }

        protected void setNumDifferent(int numDifferent) {
            this.numDifferent = numDifferent;
        }

        public int getNumPositiveSign() {
            return this.numPositiveSign;
        }

        protected void setNumPositiveSign(int numPositiveSign) {
            this.numPositiveSign = numPositiveSign;
        }

        @Override
        public double getTestStatistic() {
            return this.numPositiveSign;
        }
    }
}

