/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.method;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.statistics.method.ChebyshevInequality;
import gov.sandia.cognition.statistics.method.ConfidenceInterval;
import gov.sandia.cognition.statistics.method.ConfidenceIntervalEvaluator;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

public class BernoulliConfidence
extends AbstractCloneableSerializable
implements ConfidenceIntervalEvaluator<Collection<Boolean>> {
    public static final BernoulliConfidence INSTANCE = new BernoulliConfidence();

    @Override
    public ConfidenceInterval computeConfidenceInterval(Collection<Boolean> data, double confidence) {
        int n = 0;
        for (Boolean value : data) {
            if (!value.booleanValue()) continue;
            ++n;
        }
        double p = (double)n / (double)data.size();
        return BernoulliConfidence.computeConfidenceInterval(p, data.size(), confidence);
    }

    @PublicationReference(author={"Wikipedia"}, title="", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Margin_of_error")
    public static ConfidenceInterval computeConfidenceInterval(double bernoulliParameter, int numSamples, double confidence) {
        double p = bernoulliParameter;
        double pvar = p * (1.0 - p) / (double)numSamples;
        return INSTANCE.computeConfidenceInterval(p, pvar, numSamples, confidence);
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(double mean, double variance, int numSamples, double confidence) {
        ProbabilityUtil.assertIsProbability((double)mean);
        return ChebyshevInequality.INSTANCE.computeConfidenceInterval(mean, variance, numSamples, confidence);
    }

    @PublicationReference(author={"Wikipedia"}, title="", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Margin_of_error")
    public static int computeSampleSize(double accuracy, double confidence) {
        if (accuracy <= 0.0 || accuracy > 1.0) {
            throw new IllegalArgumentException("Accuracy must be (0,1]");
        }
        if (confidence <= 0.0 || confidence > 1.0) {
            throw new IllegalArgumentException("Confidence must be (0,1]");
        }
        double numStdDevs = Math.sqrt(1.0 / (1.0 - confidence));
        double sqrtn = numStdDevs / (2.0 * accuracy);
        int n = (int)Math.ceil(sqrtn * sqrtn);
        return n;
    }
}

