/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.InvertibleCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Normal distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Pareto_distribution")
public class ParetoDistribution
extends AbstractClosedFormSmoothUnivariateDistribution {
    public static final double DEFAULT_SHAPE = 2.0;
    public static final double DEFALUT_SCALE = 1.0;
    public static final double DEFAULT_SHIFT = 0.0;
    protected double shape;
    protected double scale;
    protected double shift;

    public ParetoDistribution() {
        this(2.0, 1.0, 0.0);
    }

    public ParetoDistribution(double shape, double scale, double shift) {
        this.setShape(shape);
        this.setScale(scale);
        this.setShift(shift);
    }

    public ParetoDistribution(ParetoDistribution other) {
        this(other.getShape(), other.getScale(), other.getShift());
    }

    @Override
    public ParetoDistribution clone() {
        return (ParetoDistribution)super.clone();
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double shape) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("Shape must be > 0.0 ");
        }
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be > 0.0 ");
        }
        this.scale = scale;
    }

    @Override
    public Double getMean() {
        if (this.shape > 1.0) {
            return this.shape * this.scale / (this.shape - 1.0) - this.shift;
        }
        throw new IllegalArgumentException("Mean is undefined when shape is <= 1.0");
    }

    @Override
    public double getVariance() {
        if (this.shape > 2.0) {
            double numerator = this.scale * this.scale * this.shape;
            double am1 = this.shape - 1.0;
            double am2 = this.shape - 2.0;
            double denominator = am1 * am1 * am2;
            return numerator / denominator;
        }
        throw new IllegalArgumentException("Variance is undefined when shape is <= 2.0");
    }

    @Override
    public ArrayList<? extends Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        double exp = 1.0 / this.shape;
        for (int n = 0; n < numSamples; ++n) {
            double u = random.nextDouble();
            samples.add(this.scale / Math.pow(u, exp) - this.shift);
        }
        return samples;
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.shape, this.scale, this.shift});
    }

    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(3);
        this.setShape(parameters.getElement(0));
        this.setScale(parameters.getElement(1));
        this.setShift(parameters.getElement(2));
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    @Override
    public Double getMinSupport() {
        return this.scale - this.shift;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public String toString() {
        return "Shape = " + this.getShape() + ", Scale = " + this.getScale() + ", Shift = " + this.getShift();
    }

    double getShift() {
        return this.shift;
    }

    public void setShift(double shift) {
        this.shift = shift;
    }

    public static class PDF
    extends ParetoDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
        }

        public PDF(double shape, double scale, double shift) {
            super(shape, scale, shift);
        }

        public PDF(ParetoDistribution other) {
            super(other);
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            if (input + this.shift > this.scale) {
                double numerator = Math.log(this.shape) + this.shape * Math.log(this.scale);
                double denominator = (this.shape + 1.0) * Math.log(input + this.shift);
                return numerator - denominator;
            }
            return Math.log(0.0);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            return Math.exp(this.logEvaluate(input));
        }
    }

    public static class CDF
    extends ParetoDistribution
    implements SmoothCumulativeDistributionFunction,
    InvertibleCumulativeDistributionFunction<Double> {
        public CDF() {
        }

        public CDF(double shape, double scale, double shift) {
            super(shape, scale, shift);
        }

        public CDF(ParetoDistribution other) {
            super(other);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            if (input + this.shift > this.scale) {
                return 1.0 - Math.pow(this.scale / (input + this.shift), this.shape);
            }
            return 0.0;
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }

        @Override
        public Double inverse(double probability) {
            if (probability <= 0.0) {
                return this.getMinSupport();
            }
            if (probability >= 1.0) {
                return this.getMaxSupport();
            }
            return this.scale / Math.pow(1.0 - probability, 1.0 / this.shape) - this.shift;
        }
    }
}

