/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.Distribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Mixture Model", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Mixture_model")
public abstract class LinearMixtureModel<DataType, DistributionType extends Distribution<DataType>>
extends AbstractDistribution<DataType> {
    protected ArrayList<? extends DistributionType> distributions;
    protected double[] priorWeights;

    public LinearMixtureModel(Collection<? extends DistributionType> distributions) {
        this(distributions, null);
    }

    public LinearMixtureModel(Collection<? extends DistributionType> distributions, double[] priorWeights) {
        if (priorWeights == null) {
            priorWeights = new double[distributions.size()];
            Arrays.fill(priorWeights, 1.0);
        }
        if (distributions.size() != priorWeights.length) {
            throw new IllegalArgumentException("Distribution count must equal number of priors");
        }
        for (int i = 0; i < priorWeights.length; ++i) {
            if (!(priorWeights[i] < 0.0)) continue;
            throw new IllegalArgumentException("weights must be >= 0.0!");
        }
        this.setDistributions(CollectionUtil.asArrayList(distributions));
        this.setPriorWeights(priorWeights);
    }

    public LinearMixtureModel<DataType, DistributionType> clone() {
        LinearMixtureModel clone = (LinearMixtureModel)super.clone();
        clone.setDistributions(ObjectUtil.cloneSmartElementsAsArrayList(this.getDistributions()));
        clone.setPriorWeights((double[])ObjectUtil.cloneSmart((Object)this.getPriorWeights()));
        return clone;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder(1000);
        retval.append("LinearMixtureModel has " + this.getDistributionCount() + " distributions:\n");
        int k = 0;
        for (Distribution distribution : this.getDistributions()) {
            retval.append(" " + k + ": Prior: " + this.getPriorWeights()[k] + ", Distribution: " + distribution + "\n");
            ++k;
        }
        return retval.toString();
    }

    public ArrayList<? extends DistributionType> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(ArrayList<? extends DistributionType> distributions) {
        this.distributions = distributions;
    }

    public int getDistributionCount() {
        return this.distributions.size();
    }

    @Override
    public DataType sample(Random random) {
        Distribution d = (Distribution)ProbabilityMassFunctionUtil.sampleSingle(this.getPriorWeights(), this.getDistributions(), random);
        return d.sample(random);
    }

    @Override
    public ArrayList<DataType> sample(Random random, int numSamples) {
        int N = this.getDistributionCount();
        double[] cumulativeWeights = new double[N];
        double sum = 0.0;
        for (int n = 0; n < N; ++n) {
            cumulativeWeights[n] = sum += this.getPriorWeights()[n];
        }
        ArrayList<Distribution> whichDistributions = ProbabilityMassFunctionUtil.sampleMultiple(cumulativeWeights, sum, this.getDistributions(), random, numSamples);
        ArrayList samples = new ArrayList(numSamples);
        for (Distribution d : whichDistributions) {
            samples.add(d.sample(random));
        }
        return samples;
    }

    public double[] getPriorWeights() {
        return this.priorWeights;
    }

    public void setPriorWeights(double[] priorWeights) {
        this.priorWeights = priorWeights;
    }

    public double getPriorWeightSum() {
        double sum = 0.0;
        int K = this.getPriorWeights().length;
        for (int k = 0; k < K; ++k) {
            sum += this.getPriorWeights()[k];
        }
        return sum <= 0.0 ? 1.0 : sum;
    }
}

