/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import gov.sandia.cognition.statistics.method.TreeSetBinner;
import java.util.Arrays;
import java.util.Collection;

@CodeReview(reviewer={"Justin Basilico"}, date="2009-05-29", changesNeeded=false, comments={"Cleaned up the formatting and javadoc."})
public class DataCountTreeSetBinnedMapHistogram<ValueType extends Comparable<? super ValueType>>
extends MapBasedDataHistogram<ValueType> {
    private TreeSetBinner<ValueType> binner;

    public DataCountTreeSetBinnedMapHistogram(TreeSetBinner<ValueType> binner) {
        this.setBinner(binner);
    }

    public DataCountTreeSetBinnedMapHistogram(Collection<? extends ValueType> binBoundaries) {
        this(new TreeSetBinner<ValueType>(binBoundaries));
    }

    public DataCountTreeSetBinnedMapHistogram(ValueType ... binBoundaries) {
        this((Collection<ValueType>)Arrays.asList(binBoundaries));
    }

    @Override
    public void add(ValueType value) {
        ValueType bin = this.getBinner().findBin(value);
        if (bin != null) {
            super.add(bin);
        }
    }

    @Override
    public void add(ValueType value, int number) {
        ValueType bin = this.getBinner().findBin(value);
        if (bin != null) {
            super.add(bin, number);
        }
    }

    @Override
    public void remove(ValueType value) {
        ValueType bin = this.getBinner().findBin(value);
        if (bin != null) {
            super.remove(bin);
        }
    }

    @Override
    public void remove(ValueType value, int number) {
        ValueType bin = this.getBinner().findBin(value);
        if (bin != null) {
            super.remove(bin, number);
        }
    }

    public int getBinCount() {
        return this.getBinner().getBinCount();
    }

    public TreeSetBinner<ValueType> getBinner() {
        return this.binner;
    }

    private void setBinner(TreeSetBinner<ValueType> binner) {
        this.binner = binner;
    }
}

