/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormSmoothUnivariateDistribution;
import gov.sandia.cognition.statistics.SmoothCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import java.util.ArrayList;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Cauchy distribution", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Cauchy_distribution")
public class CauchyDistribution
extends AbstractClosedFormSmoothUnivariateDistribution {
    public static final double DEFAULT_LOCATION = 0.0;
    public static final double DEFAULT_SCALE = 1.0;
    protected double location;
    protected double scale;

    public CauchyDistribution() {
        this(0.0, 1.0);
    }

    public CauchyDistribution(double location, double scale) {
        this.location = location;
        this.scale = scale;
    }

    public CauchyDistribution(CauchyDistribution other) {
        this(other.getLocation(), other.getScale());
    }

    @Override
    public CauchyDistribution clone() {
        CauchyDistribution clone = (CauchyDistribution)super.clone();
        return clone;
    }

    public double getLocation() {
        return this.location;
    }

    public void setLocation(double location) {
        this.location = location;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be > 0.0");
        }
        this.scale = scale;
    }

    @Override
    public Double getMean() {
        return this.getLocation();
    }

    @Override
    public ArrayList<? extends Double> sample(Random random, int numSamples) {
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        for (int n = 0; n < numSamples; ++n) {
            double g1 = random.nextGaussian();
            double g2 = random.nextGaussian();
            double ratio = g1 / g2;
            double scaled = ratio * this.scale;
            samples.add(scaled + this.location);
        }
        return samples;
    }

    @Override
    public CDF getCDF() {
        return new CDF(this);
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getLocation(), this.getScale()});
    }

    public void convertFromVector(Vector parameters) {
        parameters.assertDimensionalityEquals(2);
        this.setLocation(parameters.getElement(0));
        this.setScale(parameters.getElement(1));
    }

    @Override
    public double getVariance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public PDF getProbabilityFunction() {
        return new PDF(this);
    }

    @Override
    public Double getMinSupport() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxSupport() {
        return Double.POSITIVE_INFINITY;
    }

    public static class CDF
    extends CauchyDistribution
    implements SmoothCumulativeDistributionFunction {
        public CDF() {
            super(0.0, 1.0);
        }

        public CDF(double location, double scale) {
            super(location, scale);
        }

        public CDF(CauchyDistribution other) {
            super(other);
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            double d1 = Math.atan((input - this.location) / this.scale);
            return d1 / Math.PI + 0.5;
        }

        @Override
        public CDF getCDF() {
            return this;
        }

        @Override
        public PDF getDerivative() {
            return this.getProbabilityFunction();
        }

        public Double differentiate(Double input) {
            return this.getDerivative().evaluate(input);
        }
    }

    public static class PDF
    extends CauchyDistribution
    implements UnivariateProbabilityDensityFunction {
        public PDF() {
            super(0.0, 1.0);
        }

        public PDF(double location, double scale) {
            super(location, scale);
        }

        public PDF(CauchyDistribution other) {
            super(other);
        }

        @Override
        public double logEvaluate(Double input) {
            return this.logEvaluate((double)input);
        }

        @Override
        public double logEvaluate(double input) {
            return Math.log(this.evaluate(input));
        }

        public Double evaluate(Double input) {
            return this.evaluate((double)input);
        }

        public double evaluate(double input) {
            double leading = Math.PI * this.scale;
            double d1 = (input - this.location) / this.scale;
            double dx = 1.0 + d1 * d1;
            double denominator = leading * dx;
            return 1.0 / denominator;
        }

        @Override
        public PDF getProbabilityFunction() {
            return this;
        }
    }
}

