/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.distribution;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.IntegerCollection;
import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.ProbabilityUtil;
import gov.sandia.cognition.math.UnivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.AbstractClosedFormUnivariateDistribution;
import gov.sandia.cognition.statistics.ClosedFormCumulativeDistributionFunction;
import gov.sandia.cognition.statistics.ClosedFormDiscreteUnivariateDistribution;
import gov.sandia.cognition.statistics.DistributionEstimator;
import gov.sandia.cognition.statistics.EstimableDistribution;
import gov.sandia.cognition.statistics.ProbabilityMassFunction;
import gov.sandia.cognition.statistics.ProbabilityMassFunctionUtil;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Binomial distribution", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Binomial_distribution")
public class BinomialDistribution
extends AbstractClosedFormUnivariateDistribution<Number>
implements ClosedFormDiscreteUnivariateDistribution<Number>,
EstimableDistribution<Number, BinomialDistribution> {
    public static final double DEFAULT_P = 0.5;
    public static final int DEFAULT_N = 1;
    private int N;
    private double p;

    public BinomialDistribution() {
        this(1, 0.5);
    }

    public BinomialDistribution(int N, double p) {
        this.setN(N);
        this.setP(p);
    }

    public BinomialDistribution(BinomialDistribution other) {
        this(other.getN(), other.getP());
    }

    @Override
    public BinomialDistribution clone() {
        return (BinomialDistribution)super.clone();
    }

    @Override
    public Double getMean() {
        return (double)this.N * this.p;
    }

    @Override
    public double getVariance() {
        return (double)this.N * this.p * (1.0 - this.p);
    }

    @Override
    public ArrayList<Number> sample(Random random, int numSamples) {
        return ProbabilityMassFunctionUtil.sample(this.getProbabilityFunction(), random, numSamples);
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getN(), this.getP()});
    }

    public void convertFromVector(Vector parameters) {
        if (parameters.getDimensionality() != 2) {
            throw new IllegalArgumentException("Parameters must have dimension 2");
        }
        this.setN((int)parameters.getElement(0));
        this.setP(parameters.getElement(1));
    }

    public int getN() {
        return this.N;
    }

    public void setN(int N) {
        if (N < 1) {
            throw new IllegalArgumentException("N >= 1");
        }
        this.N = N;
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        ProbabilityUtil.assertIsProbability((double)p);
        this.p = p;
    }

    @Override
    public Collection<Integer> getDomain() {
        return new IntegerCollection(0, this.getN());
    }

    @Override
    public int getDomainSize() {
        return this.getN() + 1;
    }

    public CDF getCDF() {
        return new CDF(this);
    }

    public PMF getProbabilityFunction() {
        return new PMF(this);
    }

    @Override
    public Integer getMinSupport() {
        return 0;
    }

    @Override
    public Integer getMaxSupport() {
        return this.getN();
    }

    public MaximumLikelihoodEstimator getEstimator() {
        return new MaximumLikelihoodEstimator();
    }

    public static class MaximumLikelihoodEstimator
    extends AbstractCloneableSerializable
    implements DistributionEstimator<Number, BinomialDistribution> {
        @Override
        public PMF learn(Collection<? extends Number> data) {
            double r = UnivariateStatisticsUtil.computeMaximum(data);
            int N = (int)Math.ceil(r + 1.0 / (double)data.size());
            double psum = 0.0;
            for (Number number : data) {
                double p = number.doubleValue() / (double)N;
                psum += p;
            }
            double phat = psum / (double)data.size();
            return new PMF(N, phat);
        }
    }

    public static class CDF
    extends BinomialDistribution
    implements ClosedFormCumulativeDistributionFunction<Number> {
        public CDF() {
        }

        public CDF(int N, double p) {
            super(N, p);
        }

        public CDF(BinomialDistribution other) {
            super(other);
        }

        public Double evaluate(Number input) {
            int k = input.intValue();
            return CDF.evaluate(this.getN(), k, this.getP());
        }

        public static double evaluate(int N, int k, double p) {
            double retval = k < 0 ? 0.0 : (k >= N ? 1.0 : 1.0 - MathUtil.regularizedIncompleteBetaFunction((double)(k + 1), (double)(N - k), (double)p));
            return retval;
        }

        @Override
        public CDF getCDF() {
            return this;
        }
    }

    public static class PMF
    extends BinomialDistribution
    implements ProbabilityMassFunction<Number> {
        public PMF() {
        }

        public PMF(int N, double p) {
            super(N, p);
        }

        public PMF(BinomialDistribution other) {
            super(other);
        }

        public Double evaluate(Number input) {
            return PMF.evaluate(this.getN(), input.intValue(), this.getP());
        }

        public static double evaluate(int N, int k, double p) {
            if (k < 0) {
                return 0.0;
            }
            if (k > N) {
                return 0.0;
            }
            return Math.exp(PMF.logEvaluate(N, k, p));
        }

        @Override
        public double logEvaluate(Number input) {
            return PMF.logEvaluate(this.getN(), input.intValue(), this.getP());
        }

        public static double logEvaluate(int N, int k, double p) {
            if (k < 0) {
                return Math.log(0.0);
            }
            if (k > N) {
                return Math.log(0.0);
            }
            double n1 = MathUtil.logBinomialCoefficient((int)N, (int)k);
            double n2 = k == 0 ? 0.0 : (double)k * Math.log(p);
            double n3 = N - k == 0 ? 0.0 : (double)(N - k) * Math.log(1.0 - p);
            return n1 + n2 + n3;
        }

        @Override
        public double getEntropy() {
            return ProbabilityMassFunctionUtil.getEntropy(this);
        }

        @Override
        public PMF getProbabilityFunction() {
            return this;
        }
    }
}

