/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.distribution.ParetoDistribution;
import gov.sandia.cognition.statistics.distribution.UniformDistribution;

@PublicationReference(author={"Wikipedia"}, title="Conjugate prior", year=2010, type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Conjugate_prior")
public class UniformDistributionBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Double, Double, UniformDistribution, ParetoDistribution> {
    public UniformDistributionBayesianEstimator() {
        this(new ParetoDistribution());
    }

    public UniformDistributionBayesianEstimator(ParetoDistribution belief) {
        this(new UniformDistribution(0.0, 1.0), belief);
    }

    public UniformDistributionBayesianEstimator(UniformDistribution conditional, ParetoDistribution prior) {
        this(new Parameter(conditional, prior));
    }

    public UniformDistributionBayesianEstimator(BayesianParameter<Double, UniformDistribution, ParetoDistribution> parameter) {
        super(parameter);
    }

    public Parameter createParameter(UniformDistribution conditional, ParetoDistribution prior) {
        return new Parameter(conditional, prior);
    }

    @Override
    public void update(ParetoDistribution target, Double data) {
        double scale = Math.max(data, target.getScale());
        double shape = target.getShape() + 1.0;
        target.setShape(shape);
        target.setScale(scale);
    }

    @Override
    public double computeEquivalentSampleSize(ParetoDistribution belief) {
        return belief.getShape();
    }

    public static class Parameter
    extends AbstractBayesianParameter<Double, UniformDistribution, ParetoDistribution> {
        public static final String NAME = "maxSupport";

        public Parameter(UniformDistribution conditional, ParetoDistribution prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Double value) {
            ((UniformDistribution)this.conditionalDistribution).setMaxSupport(value);
        }

        public Double getValue() {
            return ((UniformDistribution)this.conditionalDistribution).getMaxSupport();
        }
    }
}

