/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian.conjugate;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.bayesian.AbstractBayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.conjugate.AbstractConjugatePriorBayesianEstimator;
import gov.sandia.cognition.statistics.distribution.BernoulliDistribution;
import gov.sandia.cognition.statistics.distribution.BetaDistribution;

@PublicationReference(author={"William M. Bolstad"}, title="Introduction to Bayesian Statistics: Second Edition", type=PublicationType.Book, year=2007, pages={143})
public class BernoulliBayesianEstimator
extends AbstractConjugatePriorBayesianEstimator<Number, Double, BernoulliDistribution, BetaDistribution> {
    public BernoulliBayesianEstimator() {
        this(new BetaDistribution.PDF(1.0, 1.0));
    }

    public BernoulliBayesianEstimator(BetaDistribution prior) {
        this(new BernoulliDistribution(), prior);
    }

    public BernoulliBayesianEstimator(BernoulliDistribution conditional, BetaDistribution prior) {
        this(new Parameter(conditional, prior));
    }

    protected BernoulliBayesianEstimator(BayesianParameter<Double, BernoulliDistribution, BetaDistribution> parameter) {
        super(parameter);
    }

    public Parameter createParameter(BernoulliDistribution conditional, BetaDistribution prior) {
        return new Parameter(conditional, prior);
    }

    @Override
    public void update(BetaDistribution updater, Number data) {
        if (data.intValue() != 0) {
            double alpha = updater.getAlpha();
            updater.setAlpha(alpha += 1.0);
        } else {
            double beta = updater.getBeta();
            updater.setBeta(beta += 1.0);
        }
    }

    @Override
    public double computeEquivalentSampleSize(BetaDistribution belief) {
        double alpha = belief.getAlpha();
        double beta = belief.getBeta();
        return alpha + beta + 1.0;
    }

    public static class Parameter
    extends AbstractBayesianParameter<Double, BernoulliDistribution, BetaDistribution> {
        public static final String NAME = "p";

        public Parameter(BernoulliDistribution conditional, BetaDistribution prior) {
            super(conditional, NAME, prior);
        }

        @Override
        public void setValue(Double value) {
            ((BernoulliDistribution)this.conditionalDistribution).setP(value);
        }

        public Double getValue() {
            return ((BernoulliDistribution)this.conditionalDistribution).getP();
        }
    }
}

