/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizerDerivativeFree;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.statistics.ComputableDistribution;
import gov.sandia.cognition.statistics.DataHistogram;
import gov.sandia.cognition.statistics.ProbabilityFunction;
import gov.sandia.cognition.statistics.UnivariateProbabilityDensityFunction;
import gov.sandia.cognition.statistics.bayesian.BayesianEstimator;
import gov.sandia.cognition.statistics.bayesian.BayesianParameter;
import gov.sandia.cognition.statistics.bayesian.BayesianUtil;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.AbstractRandomized;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(author={"Wikipedia"}, title="Rejection Sampling", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Rejection_sampling")
public class RejectionSampling<ObservationType, ParameterType>
extends AbstractRandomized
implements BayesianEstimator<ObservationType, ParameterType, DataHistogram<ParameterType>> {
    public static final int DEFAULT_NUM_SAMPLES = 1000;
    private int numSamples;
    protected Updater<ObservationType, ParameterType> updater;

    public RejectionSampling() {
        super(null);
        this.setNumSamples(1000);
    }

    public RejectionSampling<ObservationType, ParameterType> clone() {
        RejectionSampling clone = (RejectionSampling)super.clone();
        clone.setUpdater((Updater)ObjectUtil.cloneSafe(this.getUpdater()));
        return clone;
    }

    @Override
    public DataHistogram<ParameterType> learn(Collection<? extends ObservationType> data) {
        MapBasedDataHistogram retval = new MapBasedDataHistogram(this.getNumSamples());
        for (int n = 0; n < this.numSamples; ++n) {
            Object parameter = null;
            boolean accepted = false;
            while (!accepted) {
                parameter = this.getUpdater().makeProposal(this.getRandom());
                double acceptProbability = this.getUpdater().computeAcceptanceProbability(parameter, data);
                double p = this.getRandom().nextDouble();
                if (!(p <= acceptProbability)) continue;
                accepted = true;
                break;
            }
            retval.add(parameter);
        }
        return retval;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public Updater<ObservationType, ParameterType> getUpdater() {
        return this.updater;
    }

    public void setUpdater(Updater<ObservationType, ParameterType> updater) {
        this.updater = updater;
    }

    public static class DefaultUpdater<ObservationType, ParameterType>
    extends AbstractCloneableSerializable
    implements Updater<ObservationType, ParameterType> {
        protected BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> conjuctive;
        protected Double scale;
        private ProbabilityFunction<ParameterType> sampler;
        protected int proposals;

        public DefaultUpdater() {
            this(null);
        }

        public DefaultUpdater(BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> conjuctive) {
            this(conjuctive, conjuctive != null ? conjuctive.getParameterPrior() : null);
        }

        public DefaultUpdater(BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> conjuctive, ProbabilityFunction<ParameterType> sampler) {
            this(conjuctive, null, sampler);
        }

        public DefaultUpdater(BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> conjuctive, Double scale, ProbabilityFunction<ParameterType> sampler) {
            this.setConjuctive(conjuctive);
            this.setScale(scale);
            this.setSampler(sampler);
            this.setProposals(0);
        }

        @Override
        public double computeAcceptanceProbability(ParameterType parameter, Iterable<? extends ObservationType> data) {
            if (this.scale == null) {
                this.scale = this.computeOptimalScale(data);
            }
            this.conjuctive.setValue(parameter);
            double logSum = BayesianUtil.logLikelihood((ComputableDistribution)this.conjuctive.getConditionalDistribution(), data);
            logSum += this.conjuctive.getParameterPrior().logEvaluate(parameter);
            logSum -= this.sampler.logEvaluate(parameter);
            return Math.exp(logSum -= Math.log(this.getScale()));
        }

        /*
         * Exception decompiling
         */
        @Override
        public ParameterType makeProposal(Random random) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> getConjuctive() {
            return this.conjuctive;
        }

        public void setConjuctive(BayesianParameter<ParameterType, ? extends ProbabilityFunction<ObservationType>, ? extends ProbabilityFunction<ParameterType>> conjuctive) {
            this.conjuctive = conjuctive;
        }

        public double computeOptimalScale(Iterable<? extends ObservationType> data) {
            ScalarEstimator<ObservationType> estimator = new ScalarEstimator<ObservationType>(this.getConjuctive(), data);
            return estimator.estimateScalarFactor((UnivariateProbabilityDensityFunction)this.getSampler());
        }

        public UnivariateGaussian.PDF computeGaussianSampler(Iterable<? extends ObservationType> data, Random random, int numSamples) {
            ArrayList parameters = this.conjuctive.getParameterPrior().sample(random, numSamples);
            UnivariateGaussian.WeightedMaximumLikelihoodEstimator mle = new UnivariateGaussian.WeightedMaximumLikelihoodEstimator();
            ArrayList<DefaultWeightedValue> values = new ArrayList<DefaultWeightedValue>(parameters.size());
            for (int n = 0; n < parameters.size(); ++n) {
                Object parameter = parameters.get(n);
                if (!((Double)this.conjuctive.getParameterPrior().evaluate(parameter) > 0.0)) continue;
                this.conjuctive.setValue(parameter);
                double weight = BayesianUtil.logLikelihood((ComputableDistribution)this.conjuctive.getConditionalDistribution(), data);
                values.add(new DefaultWeightedValue((Object)((Double)parameter), weight));
            }
            return mle.learn((Collection<? extends WeightedValue<? extends Double>>)values);
        }

        public Double getScale() {
            return this.scale;
        }

        public void setScale(Double scale) {
            this.scale = scale;
        }

        public int getProposals() {
            return this.proposals;
        }

        protected void setProposals(int proposals) {
            this.proposals = proposals;
        }

        public ProbabilityFunction<ParameterType> getSampler() {
            return this.sampler;
        }

        public void setSampler(ProbabilityFunction<ParameterType> sampler) {
            this.sampler = sampler;
        }
    }

    public static interface Updater<ObservationType, ParameterType>
    extends CloneableSerializable {
        public double computeAcceptanceProbability(ParameterType var1, Iterable<? extends ObservationType> var2);

        public ParameterType makeProposal(Random var1);
    }

    public static class ScalarEstimator<ObservationType> {
        BayesianParameter<Double, ? extends ProbabilityFunction<ObservationType>, ? extends UnivariateProbabilityDensityFunction> conjunctive;
        Iterable<? extends ObservationType> data;

        public ScalarEstimator(BayesianParameter<Double, ? extends ProbabilityFunction<ObservationType>, ? extends UnivariateProbabilityDensityFunction> conjunctive, Iterable<? extends ObservationType> data) {
            this.conjunctive = conjunctive;
            this.data = data;
        }

        public double logConjunctive(Double parameter) {
            double logSum = this.conjunctive.getParameterPrior().logEvaluate(parameter);
            if (!Double.isInfinite(logSum)) {
                this.conjunctive.setValue(parameter);
                logSum += BayesianUtil.logLikelihood((ComputableDistribution)this.conjunctive.getConditionalDistribution(), this.data);
            }
            return logSum;
        }

        public double estimateScalarFactor(UnivariateProbabilityDensityFunction sampler) {
            MinimizerFunction f = new MinimizerFunction(sampler);
            LineMinimizerDerivativeFree minimizer = new LineMinimizerDerivativeFree();
            minimizer.setInitialGuess(sampler.getMean());
            InputOutputPair mode = (InputOutputPair)minimizer.learn(f);
            System.out.println("Parameter = " + mode.getInput() + " LogMode = " + mode.getOutput() + ", Mode = " + Math.exp((Double)mode.getOutput()));
            return Math.exp(-((Double)mode.getOutput()).doubleValue());
        }

        public class MinimizerFunction
        implements Evaluator<Double, Double> {
            protected ProbabilityFunction<Double> sampler;

            public MinimizerFunction(ProbabilityFunction<Double> sampler) {
                this.sampler = sampler;
            }

            public Double evaluate(Double parameter) {
                double logSampler = this.sampler.logEvaluate(parameter);
                double logCon = ScalarEstimator.this.logConjunctive(parameter);
                if (Double.isInfinite(logSampler) || Double.isInfinite(logCon)) {
                    return Double.POSITIVE_INFINITY;
                }
                return logSampler - logCon;
            }
        }
    }
}

