/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.statistics.PointMassDistribution;
import gov.sandia.cognition.statistics.bayesian.RecursiveBayesianEstimator;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.Randomized;

@PublicationReferences(references={@PublicationReference(author={"M. Sanjeev Arulampalam", "Simon Maskell", "Neil Gordon", "Tim Clapp"}, title="A Tutorial on Particle Filters for Online Nonlinear/Non-Gaussian Bayesian Tracking", type=PublicationType.Journal, publication="IEEE Transactions on Signal Processing, Vol. 50, No. 2", year=2002, pages={174, 188}, url="http://people.cs.ubc.ca/~murphyk/Software/Kalman/ParticleFilterTutorial.pdf"), @PublicationReference(author={"Wikipedia"}, title="Particle filter", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Particle_filter")})
public interface ParticleFilter<ObservationType, ParameterType>
extends RecursiveBayesianEstimator<ObservationType, ParameterType, PointMassDistribution<ParameterType>>,
Randomized {
    public Updater<ObservationType, ParameterType> getUpdater();

    public int getNumParticles();

    public void setNumParticles(int var1);

    public double computeEffectiveParticles(PointMassDistribution<ParameterType> var1);

    public static interface Updater<ObservationType, ParameterType>
    extends CloneableSerializable {
        public ParameterType update(ParameterType var1);

        public PointMassDistribution<ParameterType> createInitialParticles(int var1);

        public double computeLogLikelihood(ParameterType var1, ObservationType var2);
    }
}

