/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.signals.LinearDynamicalSystem;
import gov.sandia.cognition.statistics.bayesian.AbstractKalmanFilter;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReferences(references={@PublicationReference(author={"Wikipedia"}, title="Kalman filter", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Kalman_filter")})
public class KalmanFilter
extends AbstractKalmanFilter {
    public static final int DEFAULT_DIMENSION = 1;
    protected LinearDynamicalSystem model;

    public KalmanFilter() {
        this(1);
    }

    public KalmanFilter(int dim) {
        this(new LinearDynamicalSystem(MatrixFactory.getDefault().createIdentity(dim, dim), MatrixFactory.getDefault().createMatrix(dim, dim), MatrixFactory.getDefault().createIdentity(dim, dim)), MatrixFactory.getDefault().createIdentity(dim, dim), MatrixFactory.getDefault().createIdentity(dim, dim));
    }

    public KalmanFilter(LinearDynamicalSystem model, Matrix modelCovariance, Matrix measurementCovariance) {
        super(VectorFactory.getDefault().createVector(model.getInputDimensionality()), modelCovariance, measurementCovariance);
        this.setModel(model);
    }

    @Override
    public KalmanFilter clone() {
        KalmanFilter clone = (KalmanFilter)super.clone();
        clone.setModel((LinearDynamicalSystem)ObjectUtil.cloneSafe((CloneableSerializable)this.getModel()));
        return clone;
    }

    @Override
    public MultivariateGaussian createInitialLearnedObject() {
        return new MultivariateGaussian((Vector)this.model.getState(), this.getModelCovariance());
    }

    public LinearDynamicalSystem getModel() {
        return this.model;
    }

    public void setModel(LinearDynamicalSystem model) {
        this.model = model;
    }

    @Override
    public void predict(MultivariateGaussian belief) {
        this.getModel().evaluate((Object)this.currentInput, (CloneableSerializable)belief.getMean());
        Vector xpred = (Vector)this.model.getState();
        Matrix P = this.computePredictionCovariance(this.model.getA(), belief.getCovariance());
        belief.setMean(xpred);
        belief.setCovariance(P);
    }

    @Override
    public void measure(MultivariateGaussian belief, Vector observation) {
        Matrix C = this.model.getC();
        Vector xpred = belief.getMean();
        Vector ypred = C.times(xpred);
        Vector innovation = (Vector)observation.minus((Ring)ypred);
        this.computeMeasurementBelief(belief, innovation, C);
    }
}

