/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.statistics.bayesian;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.evaluator.StatefulEvaluator;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.NumericalDifferentiator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.statistics.bayesian.AbstractKalmanFilter;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"Wikipedia"}, title="Extended Kalman filter", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Extended_Kalman_filter")
public class ExtendedKalmanFilter
extends AbstractKalmanFilter {
    protected StatefulEvaluator<Vector, Vector, Vector> motionModel;
    protected Evaluator<Vector, Vector> observationModel;

    public ExtendedKalmanFilter() {
        this(null, null, null, null, null);
    }

    public ExtendedKalmanFilter(StatefulEvaluator<Vector, Vector, Vector> motionModel, Evaluator<Vector, Vector> observationModel, Vector currentInput, Matrix modelCovariance, Matrix measurementCovariance) {
        super(currentInput, modelCovariance, measurementCovariance);
        this.setMotionModel(motionModel);
        this.setObservationModel(observationModel);
    }

    @Override
    public ExtendedKalmanFilter clone() {
        ExtendedKalmanFilter clone = (ExtendedKalmanFilter)super.clone();
        clone.setMotionModel((StatefulEvaluator<Vector, Vector, Vector>)((StatefulEvaluator)ObjectUtil.cloneSmart(this.getMotionModel())));
        clone.setObservationModel((Evaluator<Vector, Vector>)((Evaluator)ObjectUtil.cloneSmart(this.getObservationModel())));
        return clone;
    }

    public StatefulEvaluator<Vector, Vector, Vector> getMotionModel() {
        return this.motionModel;
    }

    public void setMotionModel(StatefulEvaluator<Vector, Vector, Vector> motionModel) {
        this.motionModel = motionModel;
    }

    public Evaluator<Vector, Vector> getObservationModel() {
        return this.observationModel;
    }

    public void setObservationModel(Evaluator<Vector, Vector> observationModel) {
        this.observationModel = observationModel;
    }

    @Override
    public MultivariateGaussian createInitialLearnedObject() {
        return new MultivariateGaussian(((Vector)this.getMotionModel().getState()).clone(), this.getModelCovariance());
    }

    @Override
    public void predict(MultivariateGaussian belief) {
        Vector x = belief.getMean();
        Vector xpred = (Vector)this.getMotionModel().evaluate((Object)this.currentInput, (CloneableSerializable)x);
        Matrix A = NumericalDifferentiator.MatrixJacobian.differentiate((Vector)x, (Evaluator)new ModelJacobianEvaluator());
        Matrix P = this.computePredictionCovariance(A, belief.getCovariance());
        belief.setMean(xpred);
        belief.setCovariance(P);
    }

    @Override
    public void measure(MultivariateGaussian belief, Vector observation) {
        Vector xpred = belief.getMean();
        Vector ypred = (Vector)this.observationModel.evaluate((Object)xpred);
        Matrix C = NumericalDifferentiator.MatrixJacobian.differentiate((Vector)xpred, this.observationModel);
        Vector innovation = (Vector)observation.minus((Ring)ypred);
        this.computeMeasurementBelief(belief, innovation, C);
    }

    protected class ModelJacobianEvaluator
    implements Evaluator<Vector, Vector> {
        public Vector evaluate(Vector input) {
            ExtendedKalmanFilter.this.motionModel.setState((CloneableSerializable)input.clone());
            return (Vector)ExtendedKalmanFilter.this.motionModel.evaluate((Object)ExtendedKalmanFilter.this.currentInput);
        }
    }
}

