/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance.categorization;

import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.performance.AbstractSupervisedPerformanceEvaluator;
import gov.sandia.cognition.learning.performance.categorization.AbstractBinaryConfusionMatrix;
import gov.sandia.cognition.learning.performance.categorization.ConfusionMatrix;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.Pair;
import gov.sandia.cognition.util.Summarizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class DefaultBinaryConfusionMatrix
extends AbstractBinaryConfusionMatrix {
    protected double trueNegativesCount;
    protected double falsePositivesCount;
    protected double falseNegativesCount;
    protected double truePositivesCount;

    public DefaultBinaryConfusionMatrix() {
        this.setTruePositivesCount(0.0);
        this.setFalsePositivesCount(0.0);
        this.setTrueNegativesCount(0.0);
        this.setFalseNegativesCount(0.0);
    }

    public DefaultBinaryConfusionMatrix clone() {
        return (DefaultBinaryConfusionMatrix)super.clone();
    }

    @Override
    public void add(Boolean target, Boolean estimate, double value) {
        if (target.booleanValue()) {
            if (estimate.booleanValue()) {
                this.truePositivesCount += value;
            } else {
                this.falseNegativesCount += value;
            }
        } else if (estimate.booleanValue()) {
            this.falsePositivesCount += value;
        } else {
            this.trueNegativesCount += value;
        }
    }

    @Override
    public void clear() {
        this.setTruePositivesCount(0.0);
        this.setFalseNegativesCount(0.0);
        this.setTrueNegativesCount(0.0);
        this.setFalsePositivesCount(0.0);
    }

    @Override
    public double getTruePositivesCount() {
        return this.truePositivesCount;
    }

    public void setTruePositivesCount(double truePositivesCount) {
        ArgumentChecker.assertIsNonNegative((String)"truePositivesCount", (double)truePositivesCount);
        this.truePositivesCount = truePositivesCount;
    }

    @Override
    public double getFalsePositivesCount() {
        return this.falsePositivesCount;
    }

    public void setFalsePositivesCount(double falsePositivesCount) {
        ArgumentChecker.assertIsNonNegative((String)"falsePositivesCount", (double)falsePositivesCount);
        this.falsePositivesCount = falsePositivesCount;
    }

    @Override
    public double getTrueNegativesCount() {
        return this.trueNegativesCount;
    }

    public void setTrueNegativesCount(double trueNegativesCount) {
        ArgumentChecker.assertIsNonNegative((String)"trueNegativesCount", (double)trueNegativesCount);
        this.trueNegativesCount = trueNegativesCount;
    }

    @Override
    public double getFalseNegativesCount() {
        return this.falseNegativesCount;
    }

    public void setFalseNegativesCount(double falseNegativesCount) {
        ArgumentChecker.assertIsNonNegative((String)"falseNegativesCount", (double)falseNegativesCount);
        this.falseNegativesCount = falseNegativesCount;
    }

    public double getTrueNegativesRate() {
        double denom = this.getTrueNegativesCount() + this.getFalsePositivesCount();
        double retval = denom <= 0.0 ? 1.0 : this.getTrueNegativesCount() / denom;
        return retval;
    }

    public double getTruePositivesRate() {
        double denom = this.getTruePositivesCount() + this.getFalseNegativesCount();
        double retval = denom <= 0.0 ? 1.0 : this.getTruePositivesCount() / denom;
        return retval;
    }

    public double getFalsePositivesRate() {
        return 1.0 - this.getTrueNegativesRate();
    }

    public double getFalseNegativesRate() {
        return 1.0 - this.getTruePositivesRate();
    }

    public String toString() {
        return "True Negatives: " + this.getTrueNegativesCount() + ", " + "False Positives: " + this.getFalsePositivesCount() + ", " + "False Negatives: " + this.getFalseNegativesCount() + ", " + "True Positives: " + this.getTruePositivesCount();
    }

    public static <CategoryType> DefaultBinaryConfusionMatrix binarizeOnTrueCategory(ConfusionMatrix<CategoryType> matrix, CategoryType trueCategory) {
        return DefaultBinaryConfusionMatrix.binarizeOnTrueSet(matrix, Collections.singleton(trueCategory));
    }

    public static <CategoryType> DefaultBinaryConfusionMatrix binarizeOnTrueSet(ConfusionMatrix<CategoryType> matrix, Set<? super CategoryType> trueSet) {
        DefaultBinaryConfusionMatrix result = new DefaultBinaryConfusionMatrix();
        for (CategoryType actual : matrix.getActualCategories()) {
            boolean actualBinary = trueSet.contains(actual);
            for (CategoryType predicted : matrix.getPredictedCategories(actual)) {
                boolean predictedBinary = trueSet.contains(predicted);
                result.add(actualBinary, predictedBinary, matrix.getCount(actual, predicted));
            }
        }
        return result;
    }

    public static DefaultBinaryConfusionMatrix createFromActualPredictedPairs(Collection<? extends Pair<? extends Boolean, ? extends Boolean>> pairs) {
        DefaultBinaryConfusionMatrix result = new DefaultBinaryConfusionMatrix();
        for (Pair<? extends Boolean, ? extends Boolean> pair : pairs) {
            result.add(pair.getFirst(), pair.getSecond());
        }
        return result;
    }

    public static DefaultBinaryConfusionMatrix create(Iterable<? extends TargetEstimatePair<? extends Boolean, ? extends Boolean>> input) {
        return DefaultBinaryConfusionMatrix.create(input, true);
    }

    public static DefaultBinaryConfusionMatrix create(Iterable<? extends TargetEstimatePair<? extends Boolean, ? extends Boolean>> input, boolean weightIfAvailable) {
        double falsePositives = 0.0;
        double falseNegatives = 0.0;
        double truePositives = 0.0;
        double trueNegatives = 0.0;
        for (TargetEstimatePair<? extends Boolean, ? extends Boolean> targetEstimatePair : input) {
            double increment = weightIfAvailable ? DatasetUtil.getWeight(targetEstimatePair) : 1.0;
            boolean target = targetEstimatePair.getTarget();
            boolean estimate = targetEstimatePair.getEstimate();
            if (target) {
                if (estimate) {
                    truePositives += increment;
                    continue;
                }
                falseNegatives += increment;
                continue;
            }
            if (estimate) {
                falsePositives += increment;
                continue;
            }
            trueNegatives += increment;
        }
        DefaultBinaryConfusionMatrix result = new DefaultBinaryConfusionMatrix();
        result.setFalsePositivesCount(falsePositives);
        result.setFalseNegativesCount(falseNegatives);
        result.setTruePositivesCount(truePositives);
        result.setTrueNegativesCount(trueNegatives);
        return result;
    }

    public static class CombineSummarizer
    extends AbstractCloneableSerializable
    implements Summarizer<ConfusionMatrix<Boolean>, DefaultBinaryConfusionMatrix> {
        public DefaultBinaryConfusionMatrix summarize(Collection<? extends ConfusionMatrix<Boolean>> data) {
            DefaultBinaryConfusionMatrix result = new DefaultBinaryConfusionMatrix();
            for (ConfusionMatrix<Boolean> confusionMatrix : data) {
                result.addAll(confusionMatrix);
            }
            return result;
        }
    }

    public static class ActualPredictedPairSummarizer
    extends AbstractCloneableSerializable
    implements Summarizer<Pair<? extends Boolean, ? extends Boolean>, DefaultBinaryConfusionMatrix> {
        public DefaultBinaryConfusionMatrix summarize(Collection<? extends Pair<? extends Boolean, ? extends Boolean>> data) {
            return DefaultBinaryConfusionMatrix.createFromActualPredictedPairs(data);
        }
    }

    public static class PerformanceEvaluator<InputType>
    extends AbstractSupervisedPerformanceEvaluator<InputType, Boolean, Boolean, DefaultBinaryConfusionMatrix> {
        @Override
        public DefaultBinaryConfusionMatrix evaluatePerformance(Collection<? extends TargetEstimatePair<Boolean, Boolean>> data) {
            return DefaultBinaryConfusionMatrix.create(data);
        }
    }
}

