/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.vector;

import gov.sandia.cognition.learning.function.vector.VectorizableVectorConverter;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorFactoryContainer;
import gov.sandia.cognition.math.matrix.Vectorizable;

public class VectorizableVectorConverterWithBias
extends VectorizableVectorConverter
implements VectorFactoryContainer {
    protected VectorFactory<?> vectorFactory;

    public VectorizableVectorConverterWithBias() {
        this(VectorFactory.getDefault());
    }

    public VectorizableVectorConverterWithBias(VectorFactory<?> vectorFactory) {
        this.setVectorFactory(vectorFactory);
    }

    @Override
    public VectorizableVectorConverterWithBias clone() {
        return (VectorizableVectorConverterWithBias)super.clone();
    }

    @Override
    public Vector evaluate(Vectorizable input) {
        Vector baseVector = input.convertToVector();
        int dimensionality = baseVector.getDimensionality();
        Vector withBias = this.vectorFactory.createVector(dimensionality + 1);
        for (int i = 0; i < dimensionality; ++i) {
            withBias.setElement(i, baseVector.getElement(i));
        }
        withBias.setElement(dimensionality, 1.0);
        return withBias;
    }

    public VectorFactory<?> getVectorFactory() {
        return this.vectorFactory;
    }

    public void setVectorFactory(VectorFactory<?> vectorFactory) {
        this.vectorFactory = vectorFactory;
    }
}

