/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.summarizer;

import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Summarizer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class MostFrequentSummarizer<DataType>
extends AbstractCloneableSerializable
implements Summarizer<DataType, DataType> {
    public DataType summarize(Collection<? extends DataType> data) {
        LinkedHashMap<DataType, Integer> counts = new LinkedHashMap<DataType, Integer>();
        for (DataType item : data) {
            Integer count = (Integer)counts.get(item);
            if (count == null) {
                count = 0;
            }
            counts.put(item, count + 1);
        }
        int bestCount = 0;
        DataType best = null;
        for (Map.Entry entry : counts.entrySet()) {
            int count = (Integer)entry.getValue();
            if (count <= bestCount) continue;
            bestCount = count;
            best = (DataType)entry.getKey();
        }
        return best;
    }
}

