/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.AbstractDifferentiableUnivariateScalarFunction;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-06", changesNeeded=false, comments={"Made clone() call super.clone().", "Otherwise, class looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-05", changesNeeded=false, comments={"Class looks fine."})})
@PublicationReference(author={"Wikipedia"}, title="Sigmoid function", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Sigmoid_function")
public class SigmoidFunction
extends AbstractDifferentiableUnivariateScalarFunction {
    public SigmoidFunction clone() {
        return (SigmoidFunction)super.clone();
    }

    public double evaluate(double input) {
        return 1.0 / (1.0 + Math.exp(-input));
    }

    public double differentiate(double input) {
        double y = this.evaluate(input);
        return y * (1.0 - y);
    }
}

