/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.distance;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.Semimetric;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorUtil;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class WeightedEuclideanDistanceMetric
extends AbstractCloneableSerializable
implements Semimetric<Vectorizable> {
    protected Vector weights;

    public WeightedEuclideanDistanceMetric() {
        this(null);
    }

    public WeightedEuclideanDistanceMetric(Vector weights) {
        this.setWeights(weights);
    }

    public WeightedEuclideanDistanceMetric clone() {
        WeightedEuclideanDistanceMetric clone = (WeightedEuclideanDistanceMetric)super.clone();
        clone.weights = (Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.weights);
        return clone;
    }

    public double evaluate(Vectorizable first, Vectorizable second) {
        Vector difference = (Vector)first.convertToVector().minus((Ring)second.convertToVector());
        difference.dotTimesEquals((Ring)difference);
        return Math.sqrt(this.weights.dotProduct(difference));
    }

    public int getInputDimensionality() {
        return VectorUtil.safeGetDimensionality((Vector)this.getWeights());
    }

    public Vector getWeights() {
        return this.weights;
    }

    public void setWeights(Vector weights) {
        this.weights = weights;
    }
}

