/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.learning.function.categorization.AbstractConfidenceWeightedBinaryCategorizer;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.DiagonalMatrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;

public class DiagonalConfidenceWeightedBinaryCategorizer
extends AbstractConfidenceWeightedBinaryCategorizer {
    protected Vector variance;

    public DiagonalConfidenceWeightedBinaryCategorizer() {
        this.setVariance(null);
    }

    @Override
    public UnivariateGaussian evaluateAsGaussian(Vectorizable input) {
        if (!this.isInitialized()) {
            return new UnivariateGaussian();
        }
        Vector x = input.convertToVector();
        return new UnivariateGaussian(this.evaluateAsDouble(x), x.dotProduct((Vector)x.dotTimes((Ring)this.getVariance())));
    }

    @Override
    public boolean isInitialized() {
        return this.getMean() != null && this.getVariance() != null;
    }

    public DiagonalMatrix getCovariance() {
        return (DiagonalMatrix)MatrixFactory.getDiagonalDefault().createDiagonal((Vectorizable)this.getVariance());
    }

    public Vector getVariance() {
        return this.variance;
    }

    public void setVariance(Vector variance) {
        this.variance = variance;
    }
}

