/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.data.PartitionedDataset;
import gov.sandia.cognition.learning.experiment.AbstractLearningExperiment;
import gov.sandia.cognition.learning.performance.PerformanceEvaluator;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.Summarizer;
import java.util.ArrayList;
import java.util.Collection;

public class LearnerRepeatExperiment<InputDataType, LearnedType, StatisticType, SummaryType>
extends AbstractLearningExperiment
implements PerformanceEvaluator<BatchLearner<? super Collection<? extends InputDataType>, ? extends LearnedType>, PartitionedDataset<? extends InputDataType>, SummaryType> {
    public static final int DEFAULT_NUM_TRIALS = 10;
    protected int numTrials;
    protected PerformanceEvaluator<? super LearnedType, Collection<? extends InputDataType>, ? extends StatisticType> performanceEvaluator;
    protected Summarizer<? super StatisticType, ? extends SummaryType> summarizer;
    private BatchLearner<? super Collection<? extends InputDataType>, ? extends LearnedType> learner;
    protected ArrayList<StatisticType> statistics;
    protected SummaryType summary;

    public LearnerRepeatExperiment() {
        this(10, null, null);
    }

    public LearnerRepeatExperiment(int numTrials, PerformanceEvaluator<? super LearnedType, Collection<? extends InputDataType>, ? extends StatisticType> performanceEvaluator, Summarizer<? super StatisticType, ? extends SummaryType> summarizer) {
        this.setNumTrials(numTrials);
        this.setPerformanceEvaluator(performanceEvaluator);
        this.setSummarizer(summarizer);
        this.setStatistics(null);
        this.setSummary(null);
    }

    @Override
    public SummaryType evaluatePerformance(BatchLearner<? super Collection<? extends InputDataType>, ? extends LearnedType> learner, PartitionedDataset<? extends InputDataType> data) {
        this.setLearner(learner);
        this.setStatistics(new ArrayList(this.getNumTrials()));
        this.setSummary(null);
        this.runExperiment(data);
        this.setSummary(this.getSummarizer().summarize(this.getStatistics()));
        return this.getSummary();
    }

    protected void runExperiment(PartitionedDataset<? extends InputDataType> data) {
        this.fireExperimentStarted();
        for (int i = 1; i <= this.getNumTrials(); ++i) {
            this.fireTrialStarted();
            this.runTrial(data);
            this.fireTrialEnded();
        }
        this.fireExperimentEnded();
    }

    protected void runTrial(PartitionedDataset<? extends InputDataType> data) {
        LearnedType learned = this.getLearner().learn(data.getTrainingSet());
        Collection<? extends InputDataType> testingSet = data.getTestingSet();
        StatisticType statistic = this.getPerformanceEvaluator().evaluatePerformance(learned, testingSet);
        this.statistics.add(statistic);
    }

    public PerformanceEvaluator<? super LearnedType, Collection<? extends InputDataType>, ? extends StatisticType> getPerformanceEvaluator() {
        return this.performanceEvaluator;
    }

    public void setPerformanceEvaluator(PerformanceEvaluator<? super LearnedType, Collection<? extends InputDataType>, ? extends StatisticType> performanceEvaluator) {
        this.performanceEvaluator = performanceEvaluator;
    }

    public Summarizer<? super StatisticType, ? extends SummaryType> getSummarizer() {
        return this.summarizer;
    }

    public void setSummarizer(Summarizer<? super StatisticType, ? extends SummaryType> summarizer) {
        this.summarizer = summarizer;
    }

    public BatchLearner<? super Collection<? extends InputDataType>, ? extends LearnedType> getLearner() {
        return this.learner;
    }

    protected void setLearner(BatchLearner<? super Collection<? extends InputDataType>, ? extends LearnedType> learner) {
        this.learner = learner;
    }

    public ArrayList<StatisticType> getStatistics() {
        return this.statistics;
    }

    protected void setStatistics(ArrayList<StatisticType> statistics) {
        this.statistics = statistics;
    }

    public SummaryType getSummary() {
        return this.summary;
    }

    protected void setSummary(SummaryType summary) {
        this.summary = summary;
    }

    @Override
    public int getNumTrials() {
        return this.numTrials;
    }

    public void setNumTrials(int numTrials) {
        ArgumentChecker.assertIsPositive((String)"numTrials", (int)numTrials);
        this.numTrials = numTrials;
    }
}

