/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.learning.experiment.LearningExperiment;
import gov.sandia.cognition.learning.experiment.LearningExperimentListener;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.LinkedList;

public abstract class AbstractLearningExperiment
extends AbstractCloneableSerializable
implements LearningExperiment {
    protected transient LinkedList<LearningExperimentListener> listeners;

    public AbstractLearningExperiment() {
        this.setListeners(null);
    }

    @Override
    public void addListener(LearningExperimentListener listener) {
        if (this.getListeners() == null) {
            this.setListeners(new LinkedList<LearningExperimentListener>());
        }
        this.getListeners().add(listener);
    }

    @Override
    public void removeListener(LearningExperimentListener listener) {
        if (this.getListeners() != null) {
            this.getListeners().remove(listener);
            if (this.getListeners().isEmpty()) {
                this.setListeners(null);
            }
        }
    }

    protected void fireExperimentStarted() {
        if (this.listeners != null) {
            for (LearningExperimentListener listener : this.getListeners()) {
                listener.experimentStarted(this);
            }
        }
    }

    protected void fireExperimentEnded() {
        if (this.listeners != null) {
            for (LearningExperimentListener listener : this.getListeners()) {
                listener.experimentEnded(this);
            }
        }
    }

    protected void fireTrialStarted() {
        if (this.listeners != null) {
            for (LearningExperimentListener listener : this.getListeners()) {
                listener.trialStarted(this);
            }
        }
    }

    protected void fireTrialEnded() {
        if (this.listeners != null) {
            for (LearningExperimentListener listener : this.getListeners()) {
                listener.trialEnded(this);
            }
        }
    }

    public LinkedList<LearningExperimentListener> getListeners() {
        return this.listeners;
    }

    protected void setListeners(LinkedList<LearningExperimentListener> listeners) {
        this.listeners = listeners;
    }
}

