/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data;

import gov.sandia.cognition.learning.data.AbstractInputOutputPair;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultInputOutputPair<InputType, OutputType>
extends AbstractInputOutputPair<InputType, OutputType> {
    private InputType input;
    private OutputType output;

    public DefaultInputOutputPair() {
        this(null, null);
    }

    public DefaultInputOutputPair(InputType input, OutputType output) {
        this.setInput(input);
        this.setOutput(output);
    }

    public DefaultInputOutputPair(Pair<? extends InputType, ? extends OutputType> pair) {
        this(pair.getFirst(), pair.getSecond());
    }

    @Override
    public InputType getInput() {
        return this.input;
    }

    public void setInput(InputType input) {
        this.input = input;
    }

    @Override
    public OutputType getOutput() {
        return this.output;
    }

    public void setOutput(OutputType output) {
        this.output = output;
    }

    public static <InputType, OutputType> DefaultInputOutputPair<InputType, OutputType> create() {
        return new DefaultInputOutputPair<InputType, OutputType>();
    }

    public static <InputType, OutputType> DefaultInputOutputPair<InputType, OutputType> create(InputType input, OutputType output) {
        return new DefaultInputOutputPair<InputType, OutputType>(input, output);
    }

    public static <InputType, OutputType> ArrayList<DefaultInputOutputPair<InputType, OutputType>> mergeCollections(Collection<InputType> inputs, Collection<OutputType> outputs) {
        int count = inputs.size();
        if (count != outputs.size()) {
            throw new IllegalArgumentException("The inputs and outputs collections must be the same size (" + inputs.size() + " != " + outputs.size() + ")");
        }
        ArrayList<DefaultInputOutputPair<InputType, OutputType>> result = new ArrayList<DefaultInputOutputPair<InputType, OutputType>>(count);
        Iterator<OutputType> outputsIterator = outputs.iterator();
        for (InputType input : inputs) {
            result.add(DefaultInputOutputPair.create(input, outputsIterator.next()));
        }
        return result;
    }

    public static <InputType, OutputType> ArrayList<DefaultInputOutputPair<InputType, OutputType>> labelCollection(Collection<InputType> inputs, OutputType output) {
        int count = inputs.size();
        ArrayList<DefaultInputOutputPair<InputType, OutputType>> result = new ArrayList<DefaultInputOutputPair<InputType, OutputType>>(count);
        for (InputType input : inputs) {
            result.add(DefaultInputOutputPair.create(input, output));
        }
        return result;
    }
}

