/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.root;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.root.AbstractBracketedRootFinder;

@PublicationReference(author={"Wikipedia"}, title="Bisection method", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Bisection_method")
public class RootFinderBisectionMethod
extends AbstractBracketedRootFinder {
    @Override
    protected boolean step() {
        double xa = (Double)this.getRootBracket().getLowerBound().getInput();
        double delta = (Double)this.getRootBracket().getUpperBound().getInput() - xa;
        double xmid = xa + 0.5 * delta;
        double ymid = (Double)((Evaluator)this.data).evaluate((Object)xmid);
        InputOutputSlopeTriplet midpoint = new InputOutputSlopeTriplet(xmid, ymid, null);
        this.getRootBracket().setOtherPoint(midpoint);
        if (ymid == 0.0) {
            return false;
        }
        if ((Double)this.getRootBracket().getLowerBound().getOutput() * ymid > 0.0) {
            this.getRootBracket().setLowerBound(midpoint);
        } else {
            this.getRootBracket().setUpperBound(midpoint);
        }
        return delta > this.getTolerance();
    }
}

