/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.root;

import gov.sandia.cognition.algorithm.AnytimeAlgorithmWrapper;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizerDerivativeFree;
import gov.sandia.cognition.learning.algorithm.root.RootFinder;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.AbstractUnivariateScalarFunction;

public class MinimizerBasedRootFinder
extends AnytimeAlgorithmWrapper<InputOutputPair<Double, Double>, LineMinimizer<Evaluator<Double, Double>>>
implements RootFinder {
    private MinimizationFunction internalFunction;

    public MinimizerBasedRootFinder() {
        this(new LineMinimizerDerivativeFree());
    }

    public MinimizerBasedRootFinder(LineMinimizer<Evaluator<Double, Double>> algorithm) {
        super(algorithm);
        this.setInitialGuess(0.0);
        this.setTolerance(1.0E-5);
        this.internalFunction = null;
    }

    public InputOutputPair<Double, Double> getResult() {
        if (this.internalFunction == null || ((LineMinimizer)this.getAlgorithm()).getResult() == null) {
            return null;
        }
        Double x = (Double)((InputOutputPair)((LineMinimizer)this.getAlgorithm()).getResult()).getInput();
        return new DefaultInputOutputPair<Double, Object>(x, this.internalFunction.function.evaluate((Object)x));
    }

    @Override
    public double getInitialGuess() {
        return (Double)((LineMinimizer)this.getAlgorithm()).getInitialGuess();
    }

    @Override
    public void setInitialGuess(double intitialGuess) {
        ((LineMinimizer)this.getAlgorithm()).setInitialGuess(intitialGuess);
    }

    @Override
    public void setTolerance(double tolerance) {
        ((LineMinimizer)this.getAlgorithm()).setTolerance(tolerance);
    }

    @Override
    public double getTolerance() {
        return ((LineMinimizer)this.getAlgorithm()).getTolerance();
    }

    @Override
    public InputOutputPair<Double, Double> learn(Evaluator<Double, Double> data) {
        this.internalFunction = new MinimizationFunction(data, 0.0);
        ((LineMinimizer)this.getAlgorithm()).learn(this.internalFunction);
        return this.getResult();
    }

    private static class MinimizationFunction
    extends AbstractUnivariateScalarFunction {
        private Evaluator<Double, Double> function;
        private double functionTarget;

        public MinimizationFunction(Evaluator<Double, Double> function, double functionTarget) {
            this.function = function;
            this.functionTarget = functionTarget;
        }

        public double evaluate(double input) {
            double delta = this.functionTarget - (Double)this.function.evaluate((Object)input);
            return delta * delta;
        }
    }
}

