/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron.kernel;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.kernel.AbstractOnlineBudgetedKernelBinaryCategorizerLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.learning.function.kernel.KernelUtil;
import gov.sandia.cognition.util.DefaultWeightedValue;
import java.util.LinkedList;

@PublicationReference(author={"Ofer Dekel", "Shai Shalev-Shwartz", "Yoram Singer"}, title="The Forgetron: A Kernel-based Perceptron on a Budget", year=2008, type=PublicationType.Journal, publication="SIAM Journal on Computing", pages={1342, 1372}, url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.134.7604&rep=rep1&type=pdf", notes={"This is the self-tuned version."})
public class Forgetron<InputType>
extends AbstractOnlineBudgetedKernelBinaryCategorizerLearner<InputType> {
    public Forgetron() {
        this(null, 100);
    }

    public Forgetron(Kernel<? super InputType> kernel, int budget) {
        super(kernel, budget);
    }

    @Override
    public DefaultKernelBinaryCategorizer<InputType> createInitialLearnedObject() {
        return new Result(this.getKernel());
    }

    @Override
    public void update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean label) {
        double actual;
        double prediction = target.evaluateAsDouble(input);
        double margin = prediction * (actual = label ? 1.0 : -1.0);
        if (margin > 0.0) {
            return;
        }
        Result result = (Result)target;
        ++result.errorCount;
        result.add(input, actual);
        while (target.getExampleCount() > this.getBudget()) {
            this.shrink(result);
        }
    }

    protected void shrink(Result<InputType> result) {
        DefaultWeightedValue oldest = result.get(0);
        double oldestWeight = oldest.getWeight();
        double sigmaOldest = Math.abs(oldestWeight);
        double yOldest = oldestWeight >= 0.0 ? 1.0 : -1.0;
        double fOldest = result.evaluateAsDouble(oldest.getValue());
        double a = sigmaOldest * sigmaOldest - 2.0 * sigmaOldest * yOldest * fOldest;
        double b = 2.0 * sigmaOldest;
        double c = result.q - 0.46875 * (double)result.errorCount;
        double d = b * b - 4.0 * a * c;
        double update = a > 0.0 || a < 0.0 && d > 0.0 && (-b - Math.sqrt(d)) / (2.0 * a) > 1.0 ? Math.min(1.0, (-b + Math.sqrt(d)) / (2.0 * a)) : (a == 0.0 ? Math.min(1.0, -c / b) : 1.0);
        if (update != 1.0) {
            KernelUtil.scaleEquals(result, update);
        }
        result.q += (sigmaOldest *= update) * sigmaOldest + 2.0 * sigmaOldest - 2.0 * sigmaOldest * yOldest * (fOldest *= update);
        result.remove(0);
    }

    @PublicationReference(author={"Ofer Dekel", "Shai Shalev-Shwartz", "Yoram Singer"}, title="The Forgetron: A Kernel-based Perceptron on a Budget", year=2008, type=PublicationType.Journal, publication="SIAM Journal on Computing", pages={1342, 1372}, url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.134.7604&rep=rep1&type=pdf", notes={"This is the greedy version."})
    public static class Greedy<InputType>
    extends Forgetron<InputType> {
        public Greedy() {
            this(null, 100);
        }

        public Greedy(Kernel<? super InputType> kernel, int budget) {
            super(kernel, budget);
        }

        @Override
        protected void shrink(Result<InputType> result) {
            double threshold = 0.46875;
            int i = 0;
            for (DefaultWeightedValue example : result.getExamples()) {
                double f;
                double y;
                double weight = example.getWeight();
                double sigma = Math.abs(weight);
                double psi = sigma * sigma + 2.0 * sigma - 2.0 * sigma * (y = weight >= 0.0 ? 1.0 : -1.0) * (f = result.evaluateAsDouble(example.getValue()));
                if (psi <= 0.46875) {
                    result.remove(i);
                    return;
                }
                ++i;
            }
            super.shrink(result);
        }
    }

    @PublicationReference(author={"Ofer Dekel", "Shai Shalev-Shwartz", "Yoram Singer"}, title="The Forgetron: A Kernel-based Perceptron on a Budget", year=2008, type=PublicationType.Journal, publication="SIAM Journal on Computing", pages={1342, 1372}, url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.134.7604&rep=rep1&type=pdf", notes={"This is the basic version."})
    public static class Basic<InputType>
    extends AbstractOnlineBudgetedKernelBinaryCategorizerLearner<InputType> {
        public Basic() {
            this(null, 100);
        }

        public Basic(Kernel<? super InputType> kernel, int budget) {
            super(kernel, budget);
        }

        @Override
        public DefaultKernelBinaryCategorizer<InputType> createInitialLearnedObject() {
            return new DefaultKernelBinaryCategorizer(this.getKernel(), new LinkedList(), 0.0);
        }

        @Override
        public void update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean label) {
            double actual;
            double prediction = target.evaluateAsDouble(input);
            double margin = prediction * (actual = label ? 1.0 : -1.0);
            if (margin > 0.0) {
                return;
            }
            target.add(input, actual);
            double norm = KernelUtil.norm2(target);
            double b = this.budget + 1;
            double r = Math.pow(b, -1.0 / (2.0 * b));
            double u = 0.25 * Math.sqrt(b / Math.log(b));
            double update = Math.min(r, u / norm);
            KernelUtil.scaleEquals(target, update);
            while (target.getExampleCount() > this.budget) {
                target.remove(0);
            }
        }
    }

    public static class Result<InputType>
    extends DefaultKernelBinaryCategorizer<InputType> {
        protected long errorCount;
        protected double q;

        public Result() {
            this((Kernel<InputType>)null);
        }

        public Result(Kernel<? super InputType> kernel) {
            super(kernel, new LinkedList(), 0.0);
            this.setErrorCount(this.errorCount);
            this.setQ(this.q);
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        protected void setErrorCount(long errorCount) {
            this.errorCount = errorCount;
        }

        protected double getQ() {
            return this.q;
        }

        protected void setQ(double q) {
            this.q = q;
        }
    }
}

