/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.nearest;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.nearest.AbstractNearestNeighbor;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.DivergenceFunction;
import gov.sandia.cognition.math.Metric;
import gov.sandia.cognition.math.geometry.KDTree;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Collection;

public class NearestNeighborKDTree<InputType extends Vectorizable, OutputType>
extends AbstractNearestNeighbor<InputType, OutputType> {
    private KDTree<InputType, OutputType, InputOutputPair<? extends InputType, OutputType>> data;

    public NearestNeighborKDTree() {
        this(null, null);
    }

    public NearestNeighborKDTree(KDTree<InputType, OutputType, InputOutputPair<? extends InputType, OutputType>> data, DivergenceFunction<? super InputType, ? super InputType> divergenceFunction) {
        super(divergenceFunction);
        this.setData(data);
    }

    @Override
    public NearestNeighborKDTree<InputType, OutputType> clone() {
        NearestNeighborKDTree clone = (NearestNeighborKDTree)super.clone();
        clone.setData((KDTree)ObjectUtil.cloneSafe(this.getData()));
        return clone;
    }

    public Metric<? super InputType> getDivergenceFunction() {
        return (Metric)super.getDivergenceFunction();
    }

    @Override
    public void setDivergenceFunction(DivergenceFunction<? super InputType, ? super InputType> divergenceFunction) {
        this.setDivergenceFunction((Metric)divergenceFunction);
    }

    public void setDivergenceFunction(Metric<? super InputType> divergenceFunction) {
        super.setDivergenceFunction(divergenceFunction);
    }

    public KDTree<InputType, OutputType, InputOutputPair<? extends InputType, OutputType>> getData() {
        return this.data;
    }

    public void setData(KDTree<InputType, OutputType, InputOutputPair<? extends InputType, OutputType>> data) {
        this.data = data;
    }

    public OutputType evaluate(InputType input) {
        Collection neighbors = this.getData().findNearest(input, 1, this.getDivergenceFunction());
        InputOutputPair pair = (InputOutputPair)CollectionUtil.getFirst((Iterable)neighbors);
        if (pair != null) {
            return pair.getOutput();
        }
        return null;
    }

    public static class Learner<InputType extends Vectorizable, OutputType>
    extends NearestNeighborKDTree<InputType, OutputType>
    implements SupervisedBatchLearner<InputType, OutputType, NearestNeighborKDTree<InputType, OutputType>> {
        public Learner() {
            this((Metric<Vectorizable>)null);
        }

        public Learner(Metric<? super Vectorizable> divergenceFunction) {
            super(null, divergenceFunction);
        }

        @Override
        public NearestNeighborKDTree<InputType, OutputType> learn(Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
            CloneableSerializable clone = this.clone();
            KDTree tree = KDTree.createBalanced(data);
            clone.setData(tree);
            return clone;
        }
    }
}

