/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.nearest;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.nearest.AbstractNearestNeighbor;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.distance.DefaultDivergenceFunctionContainer;
import gov.sandia.cognition.math.DivergenceFunction;
import java.util.Collection;
import java.util.LinkedList;

@PublicationReference(author={"Wikipedia"}, title="k-nearest neighbor algorithm", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/K-nearest_neighbor_algorithm")
public class NearestNeighborExhaustive<InputType, OutputType>
extends AbstractNearestNeighbor<InputType, OutputType> {
    protected LinkedList<InputOutputPair<? extends InputType, OutputType>> data;

    public NearestNeighborExhaustive() {
        this((DivergenceFunction<InputType, InputType>)null);
    }

    public NearestNeighborExhaustive(DivergenceFunction<? super InputType, ? super InputType> divergenceFunction) {
        this(divergenceFunction, null);
    }

    public NearestNeighborExhaustive(DivergenceFunction<? super InputType, ? super InputType> divergenceFunction, Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
        super(divergenceFunction);
        this.setData(new LinkedList<InputOutputPair<? extends InputType, OutputType>>());
        if (data != null) {
            ((LinkedList)this.getData()).addAll(data);
        }
    }

    @Override
    public NearestNeighborExhaustive<InputType, OutputType> clone() {
        NearestNeighborExhaustive clone = (NearestNeighborExhaustive)super.clone();
        clone.setData(new LinkedList<InputOutputPair<? extends InputType, OutputType>>());
        if (this.getData() != null) {
            ((LinkedList)clone.getData()).addAll(this.getData());
        }
        return clone;
    }

    public OutputType evaluate(InputType input) {
        InputOutputPair bestExample = null;
        double bestDivergence = Double.MAX_VALUE;
        for (InputOutputPair example : this.getData()) {
            double divergence = this.divergenceFunction.evaluate(input, example.getInput());
            if (bestExample != null && !(divergence < bestDivergence)) continue;
            bestExample = example;
            bestDivergence = divergence;
        }
        if (bestExample != null) {
            return bestExample.getOutput();
        }
        return null;
    }

    @Override
    public LinkedList<InputOutputPair<? extends InputType, OutputType>> getData() {
        return this.data;
    }

    public void setData(LinkedList<InputOutputPair<? extends InputType, OutputType>> data) {
        this.data = data;
    }

    public static class Learner<InputType, OutputType>
    extends DefaultDivergenceFunctionContainer<InputType, InputType>
    implements SupervisedBatchLearner<InputType, OutputType, NearestNeighborExhaustive<InputType, OutputType>> {
        public Learner() {
            this((DivergenceFunction<InputType, InputType>)null);
        }

        public Learner(DivergenceFunction<? super InputType, ? super InputType> divergenceFunction) {
            super(divergenceFunction);
        }

        @Override
        public NearestNeighborExhaustive<InputType, OutputType> learn(Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
            return new NearestNeighborExhaustive(this.getDivergenceFunction(), data);
        }
    }
}

