/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.nearest;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.nearest.AbstractKNearestNeighbor;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.math.DivergenceFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.Summarizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.PriorityQueue;

@PublicationReference(author={"Wikipedia"}, title="k-nearest neighbor algorithm", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/K-nearest_neighbor_algorithm")
public class KNearestNeighborExhaustive<InputType, OutputType>
extends AbstractKNearestNeighbor<InputType, OutputType> {
    private Collection<InputOutputPair<? extends InputType, OutputType>> data;

    public KNearestNeighborExhaustive() {
        this(1, null, null, null);
    }

    public KNearestNeighborExhaustive(int k, Collection<? extends InputOutputPair<? extends InputType, OutputType>> data, DivergenceFunction<? super InputType, ? super InputType> divergenceFunction, Summarizer<? super OutputType, ? extends OutputType> averager) {
        super(k, divergenceFunction, averager);
        this.setData(new LinkedList<InputOutputPair<? extends InputType, OutputType>>());
        if (data != null) {
            this.getData().addAll(data);
        }
    }

    @Override
    public KNearestNeighborExhaustive<InputType, OutputType> clone() {
        KNearestNeighborExhaustive clone = (KNearestNeighborExhaustive)super.clone();
        clone.setData(new LinkedList<InputOutputPair<? extends InputType, OutputType>>(this.getData()));
        return clone;
    }

    @Override
    protected Collection<OutputType> computeNeighborhood(InputType key) {
        int maxNumNeighbors = this.getK();
        PriorityQueue<Neighbor> neighbors = new PriorityQueue<Neighbor>();
        for (InputOutputPair<InputType, OutputType> example : this.getData()) {
            double divergence = this.getDivergenceFunction().evaluate(key, example.getFirst());
            if (neighbors.size() < maxNumNeighbors) {
                neighbors.add(new Neighbor(example.getSecond(), divergence));
                continue;
            }
            if (!(divergence < ((Neighbor)neighbors.peek()).divergence)) continue;
            neighbors.remove();
            neighbors.add(new Neighbor(example.getSecond(), divergence));
        }
        ArrayList<Object> nearest = new ArrayList<Object>(neighbors.size());
        for (Neighbor neighbor : neighbors) {
            nearest.add(neighbor.value);
        }
        return nearest;
    }

    @Override
    public Collection<InputOutputPair<? extends InputType, OutputType>> getData() {
        return this.data;
    }

    public void setData(Collection<InputOutputPair<? extends InputType, OutputType>> data) {
        this.data = data;
    }

    public static class Learner<InputType, OutputType>
    extends KNearestNeighborExhaustive<InputType, OutputType>
    implements SupervisedBatchLearner<InputType, OutputType, KNearestNeighborExhaustive<InputType, OutputType>> {
        public Learner() {
            this(1, (DivergenceFunction<InputType, InputType>)null, (Summarizer<OutputType, OutputType>)null);
        }

        public Learner(int k, DivergenceFunction<? super InputType, ? super InputType> divergenceFunction, Summarizer<? super OutputType, OutputType> averager) {
            super(k, null, divergenceFunction, averager);
        }

        @Override
        public KNearestNeighborExhaustive<InputType, OutputType> learn(Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
            ArrayList<? extends InputOutputPair<? extends InputType, OutputType>> list = new ArrayList<InputOutputPair<? extends InputType, OutputType>>(data);
            return new KNearestNeighborExhaustive(this.getK(), list, this.getDivergenceFunction(), this.getAverager());
        }
    }

    protected class Neighbor
    extends AbstractCloneableSerializable
    implements Comparable<Neighbor> {
        private OutputType value;
        private double divergence;

        public Neighbor(OutputType value, double divergence) {
            this.value = value;
            this.divergence = divergence;
        }

        @Override
        public int compareTo(Neighbor other) {
            return -Double.compare(this.divergence, other.divergence);
        }
    }
}

