/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line.interpolator;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.AbstractLineBracketInterpolator;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.LineBracketInterpolatorLinear;
import gov.sandia.cognition.learning.data.InputOutputPair;

@PublicationReferences(references={@PublicationReference(author={"Wikipedia"}, title="Golden section search", type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Golden_section_search", year=2008), @PublicationReference(author={"Jeffrey Naisbitt", "Michael Heath"}, title="Golden Section Search", type=PublicationType.WebPage, url="http://www.cse.uiuc.edu/iem/optimization/GoldenSection/", year=2008), @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={401, 402}, url="http://www.nrbook.com/a/bookcpdf.php")})
public class LineBracketInterpolatorGoldenSection
extends AbstractLineBracketInterpolator<Evaluator<Double, Double>> {
    private LineBracketInterpolatorLinear linearInterpolator = new LineBracketInterpolatorLinear();
    public static final double GOLDEN_RATIO = 1.618034;
    public static final double GOLDEN_RATIO_CONJUGATE = 0.618034;

    public LineBracketInterpolatorGoldenSection() {
        super(1.0E-6);
    }

    @Override
    public double findMinimum(LineBracket bracket, double minx, double maxx, Evaluator<Double, Double> function) {
        double x = LineBracketInterpolatorGoldenSection.step(bracket.getLowerBound(), bracket.getUpperBound(), this.getTolerance());
        if (minx <= x && x <= maxx) {
            return x;
        }
        return this.linearInterpolator.findMinimum(bracket, minx, maxx, function);
    }

    public static double step(InputOutputPair<Double, Double> a, InputOutputPair<Double, Double> b, double tolerance) {
        double delta = b.getInput() - a.getInput();
        if (Math.abs(delta) < tolerance) {
            throw new IllegalArgumentException("Golden section delta has effectively collapsed: " + delta);
        }
        double x = a.getOutput() < b.getOutput() ? a.getInput() + 0.618034 * delta : b.getInput() - 0.618034 * delta;
        return x;
    }

    @Override
    public boolean hasSufficientPoints(LineBracket bracket) {
        return bracket.getLowerBound() != null && bracket.getUpperBound() != null;
    }
}

