/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.AbstractAnytimeLineMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.LineBracketInterpolator;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.LineBracketInterpolatorBrent;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={400, 405}, url="http://www.nrbook.com/a/bookcpdf.php")
public class LineMinimizerDerivativeFree
extends AbstractAnytimeLineMinimizer<Evaluator<Double, Double>> {
    public static final double STEP_MAX = 100.0;
    public static final LineBracketInterpolator<? super Evaluator<Double, Double>> DEFAULT_INTERPOLATOR = new LineBracketInterpolatorBrent();

    public LineMinimizerDerivativeFree() {
        this((LineBracketInterpolator)ObjectUtil.cloneSafe(DEFAULT_INTERPOLATOR));
    }

    public LineMinimizerDerivativeFree(LineBracketInterpolator<? super Evaluator<Double, Double>> interpolator) {
        super(interpolator);
    }

    @Override
    @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={400, 401}, url="http://www.nrbook.com/a/bookcpdf.php")
    public boolean bracketingStep() {
        boolean validBracket;
        Evaluator f = (Evaluator)this.data;
        LineBracket bracket = this.getBracket();
        if (bracket.getLowerBound() == null) {
            double x = (Double)this.getInitialGuess();
            double fx = this.getInitialGuessFunctionValue() != null ? this.getInitialGuessFunctionValue() : (Double)f.evaluate((Object)x);
            bracket.setLowerBound(new InputOutputSlopeTriplet(x, fx, null));
        }
        if (bracket.getOtherPoint() == null) {
            double step = 1.0;
            if (this.getInitialGuessSlope() != null && this.getInitialGuessSlope() > 0.0) {
                step = -1.0;
            }
            double x = (Double)bracket.getLowerBound().getInput() - step;
            double fx = (Double)f.evaluate((Object)x);
            InputOutputSlopeTriplet b = new InputOutputSlopeTriplet(x, fx, null);
            if ((Double)bracket.getLowerBound().getOutput() < (Double)b.getOutput()) {
                bracket.setOtherPoint(bracket.getLowerBound());
                bracket.setLowerBound(b);
            } else {
                bracket.setOtherPoint(b);
            }
        }
        if (bracket.getUpperBound() == null) {
            double ax = (Double)bracket.getLowerBound().getInput();
            double bx = (Double)bracket.getOtherPoint().getInput();
            double cx = bx + 1.618034 * (bx - ax);
            double fcx = (Double)f.evaluate((Object)cx);
            bracket.setUpperBound(new InputOutputSlopeTriplet(cx, fcx, null));
        }
        InputOutputSlopeTriplet a = bracket.getLowerBound();
        InputOutputSlopeTriplet b = bracket.getOtherPoint();
        InputOutputSlopeTriplet c = bracket.getUpperBound();
        if ((Double)a.getOutput() < (Double)b.getOutput()) {
            throw new IllegalArgumentException("Discovered a.getOutput < b.getOutput!  This should never happen during bracketing!");
        }
        if ((Double)b.getOutput() > (Double)c.getOutput()) {
            double maxx;
            double minx = (Double)b.getInput();
            if (minx > (maxx = minx + 100.0 * ((Double)c.getInput() - (Double)b.getInput()))) {
                double temp = minx;
                minx = maxx;
                maxx = temp;
            }
            double xstar = this.getInterpolator().findMinimum(bracket, minx, maxx, f);
            double fxstar = (Double)f.evaluate((Object)xstar);
            InputOutputSlopeTriplet star = new InputOutputSlopeTriplet(xstar, fxstar, null);
            this.result = star;
            if (((Double)b.getInput() - xstar) * (xstar - (Double)c.getInput()) > 0.0) {
                if (fxstar < (Double)c.getOutput()) {
                    bracket.setLowerBound(b);
                    bracket.setOtherPoint(star);
                    validBracket = true;
                } else if ((Double)b.getOutput() < fxstar) {
                    bracket.setUpperBound(star);
                    validBracket = true;
                } else {
                    bracket.setOtherPoint(star);
                    validBracket = false;
                }
            } else {
                bracket.setLowerBound(b);
                bracket.setOtherPoint(c);
                bracket.setUpperBound(new InputOutputSlopeTriplet(xstar, fxstar, null));
                validBracket = (Double)c.getOutput() < fxstar;
            }
        } else {
            validBracket = true;
        }
        if (validBracket && (Double)bracket.getLowerBound().getInput() > (Double)bracket.getUpperBound().getInput()) {
            InputOutputSlopeTriplet temp = bracket.getLowerBound();
            bracket.setLowerBound(bracket.getUpperBound());
            bracket.setUpperBound(temp);
        }
        return validBracket;
    }

    @Override
    @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={404, 405}, url="http://www.nrbook.com/a/bookcpdf.php")
    public boolean sectioningStep() {
        LineBracket bracket = this.getBracket();
        InputOutputSlopeTriplet a = bracket.getLowerBound();
        InputOutputSlopeTriplet b = bracket.getOtherPoint();
        InputOutputSlopeTriplet c = bracket.getUpperBound();
        double dab = (Double)a.getOutput() - (Double)b.getOutput();
        double dbc = (Double)b.getOutput() - (Double)c.getOutput();
        double minx = (Double)a.getInput() + this.getTolerance() * Math.signum((Double)a.getInput());
        double maxx = (Double)c.getInput() - this.getTolerance() * Math.signum((Double)c.getInput());
        double midx = 0.5 * (minx + maxx);
        double convergenceThreshold = this.getTolerance() * Math.abs((Double)b.getInput()) - 0.5 * (maxx - minx);
        if (Math.abs(midx - (Double)b.getInput()) <= convergenceThreshold || Math.max(Math.abs(dab), Math.abs(dbc)) < this.getTolerance()) {
            this.result = b;
            return false;
        }
        Evaluator f = (Evaluator)this.data;
        double xstar = this.getInterpolator().findMinimum(bracket, minx, maxx, f);
        double fxstar = (Double)f.evaluate((Object)xstar);
        InputOutputSlopeTriplet star = new InputOutputSlopeTriplet(xstar, fxstar, null);
        if (fxstar < (Double)b.getOutput()) {
            if (xstar <= (Double)b.getInput()) {
                c = b;
                b = star;
            } else {
                a = b;
                b = star;
            }
        } else if (xstar <= (Double)b.getInput()) {
            a = star;
        } else {
            c = star;
        }
        this.result = b;
        bracket.setLowerBound(a);
        bracket.setOtherPoint(b);
        bracket.setUpperBound(c);
        return true;
    }
}

