/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizer;
import gov.sandia.cognition.learning.data.InputOutputPair;

public abstract class AbstractAnytimeFunctionMinimizer<InputType, OutputType, EvaluatorType extends Evaluator<? super InputType, ? extends OutputType>>
extends AbstractAnytimeBatchLearner<EvaluatorType, InputOutputPair<InputType, OutputType>>
implements FunctionMinimizer<InputType, OutputType, EvaluatorType> {
    protected double tolerance;
    protected InputOutputPair<InputType, OutputType> result;
    protected InputType initialGuess;

    public AbstractAnytimeFunctionMinimizer(InputType initialGuess, double tolerance, int maxIterations) {
        super(maxIterations);
        this.setTolerance(tolerance);
        this.setInitialGuess(initialGuess);
        this.setResult(null);
    }

    public InputOutputPair<InputType, OutputType> getResult() {
        return this.result;
    }

    protected void setResult(InputOutputPair<InputType, OutputType> result) {
        this.result = result;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public void setTolerance(double tolerance) {
        if (tolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be >= 0.0");
        }
        this.tolerance = tolerance;
    }

    @Override
    public InputType getInitialGuess() {
        return this.initialGuess;
    }

    @Override
    public void setInitialGuess(InputType initialGuess) {
        this.initialGuess = initialGuess;
    }
}

