/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.genetic.reproducer;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.annealing.Perturber;
import gov.sandia.cognition.learning.algorithm.genetic.EvaluatedGenome;
import gov.sandia.cognition.learning.algorithm.genetic.reproducer.Reproducer;
import gov.sandia.cognition.learning.algorithm.genetic.selector.Selector;
import java.util.ArrayList;
import java.util.Collection;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Moved previous code review as CodeReview annotation", "Looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-04", changesNeeded=false, comments={"Minor changes made.", "Looks good."})})
public class MutationReproducer<GenomeType>
implements Reproducer<GenomeType> {
    private Perturber<GenomeType> perturber;
    private Selector<GenomeType> selector;

    public MutationReproducer(Perturber<GenomeType> perturber, Selector<GenomeType> selector) {
        this.setPerturber(perturber);
        this.setSelector(selector);
    }

    @Override
    public Collection<GenomeType> reproduce(Collection<EvaluatedGenome<GenomeType>> genomes) {
        Collection<EvaluatedGenome<GenomeType>> selectedGenomes = this.getSelector().select(genomes);
        ArrayList<GenomeType> newGenomes = new ArrayList<GenomeType>(selectedGenomes.size());
        for (EvaluatedGenome<GenomeType> genome : selectedGenomes) {
            newGenomes.add(this.getPerturber().perturb(genome.getGenome()));
        }
        return newGenomes;
    }

    public Perturber<GenomeType> getPerturber() {
        return this.perturber;
    }

    public Selector<GenomeType> getSelector() {
        return this.selector;
    }

    public void setPerturber(Perturber<GenomeType> perturber) {
        this.perturber = perturber;
    }

    public void setSelector(Selector<GenomeType> selector) {
        this.selector = selector;
    }
}

