/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.genetic;

import gov.sandia.cognition.algorithm.ParallelAlgorithm;
import gov.sandia.cognition.algorithm.ParallelUtil;
import gov.sandia.cognition.learning.algorithm.genetic.EvaluatedGenome;
import gov.sandia.cognition.learning.algorithm.genetic.GeneticAlgorithm;
import gov.sandia.cognition.learning.algorithm.genetic.reproducer.Reproducer;
import gov.sandia.cognition.learning.data.SequentialDataMultiPartitioner;
import gov.sandia.cognition.learning.function.cost.CostFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelizedGeneticAlgorithm<CostParametersType, GenomeType>
extends GeneticAlgorithm<CostParametersType, GenomeType>
implements ParallelAlgorithm {
    private ArrayList<Callable<ArrayList<EvaluatedGenome<GenomeType>>>> evaluateTasks;
    private transient ThreadPoolExecutor threadPool;

    public ParallelizedGeneticAlgorithm() {
        this(null, null, null, null);
    }

    public ParallelizedGeneticAlgorithm(Collection<GenomeType> initialPopulation, Reproducer<GenomeType> reproducer, CostFunction<? super GenomeType, ? super CostParametersType> cost, ThreadPoolExecutor threadPool) {
        super(initialPopulation, reproducer, cost);
        this.setThreadPool(threadPool);
    }

    public ParallelizedGeneticAlgorithm(Collection<GenomeType> initialPopulation, Reproducer<GenomeType> reproducer, CostFunction<? super GenomeType, ? super CostParametersType> cost, ThreadPoolExecutor threadPool, int maxIterations, int maxIterationsWithoutImprovement) {
        super(initialPopulation, reproducer, cost, maxIterations, maxIterationsWithoutImprovement);
        this.setThreadPool(threadPool);
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public int getNumThreads() {
        return ParallelUtil.getNumThreads((ParallelAlgorithm)this);
    }

    protected void createEvaluationTasks(Collection<GenomeType> population) {
        if (this.getThreadPool() == null) {
            this.setThreadPool(ParallelUtil.createThreadPool());
        }
        int numThreads = this.getNumThreads();
        ArrayList<ArrayList<GenomeType>> partitions = SequentialDataMultiPartitioner.create(population, numThreads);
        this.evaluateTasks = new ArrayList(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            this.evaluateTasks.add(new EvaluateGenome(partitions.get(i)));
        }
    }

    @Override
    protected ArrayList<EvaluatedGenome<GenomeType>> evaluatePopulation(Collection<GenomeType> population) {
        if (population == null) {
            return null;
        }
        this.createEvaluationTasks(population);
        ArrayList<EvaluatedGenome<GenomeType>> evaluatedPopulation = new ArrayList<EvaluatedGenome<GenomeType>>(population.size());
        try {
            List<Future<ArrayList<EvaluatedGenome<GenomeType>>>> results = this.getThreadPool().invokeAll(this.evaluateTasks);
            for (Future<ArrayList<EvaluatedGenome<GenomeType>>> result : results) {
                evaluatedPopulation.addAll(0, (Collection)result.get());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ParallelizedGeneticAlgorithm.class.getName()).log(Level.SEVERE, null, ex);
        }
        return evaluatedPopulation;
    }

    protected class EvaluateGenome
    implements Callable<ArrayList<EvaluatedGenome<GenomeType>>> {
        private Collection<GenomeType> population;

        public EvaluateGenome(ArrayList<GenomeType> population) {
            this.population = population;
        }

        @Override
        public ArrayList<EvaluatedGenome<GenomeType>> call() {
            return ParallelizedGeneticAlgorithm.super.evaluatePopulation(this.population);
        }
    }
}

