/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.ensemble;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeSupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearnerContainer;
import gov.sandia.cognition.learning.algorithm.ensemble.WeightedVotingCategorizerEnsemble;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.DefaultWeightedInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

@PublicationReference(author={"Yoav Freund", "Robert E.Schapire"}, title="A decision-theoretic generalization of on-line learning and an application to boosting", publication="Journal of Computer and System Sciences", notes={"Volume 55, Number 1"}, year=1997, pages={119, 139}, type=PublicationType.Journal, url="http://www.cse.ucsd.edu/~yfreund/papers/adaboost.pdf")
public class MultiCategoryAdaBoost<InputType, CategoryType>
extends AbstractAnytimeSupervisedBatchLearner<InputType, CategoryType, WeightedVotingCategorizerEnsemble<InputType, CategoryType, Evaluator<? super InputType, ? extends CategoryType>>>
implements BatchLearnerContainer<BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>>> {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    protected BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> weakLearner;
    protected transient WeightedVotingCategorizerEnsemble<InputType, CategoryType, Evaluator<? super InputType, ? extends CategoryType>> ensemble;
    protected transient ArrayList<DefaultWeightedInputOutputPair<InputType, CategoryType>> weightedData;

    public MultiCategoryAdaBoost() {
        this(null, 100);
    }

    public MultiCategoryAdaBoost(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> weakLearner, int maxIterations) {
        super(maxIterations);
        this.setWeakLearner(weakLearner);
    }

    @Override
    protected boolean initializeAlgorithm() {
        if (CollectionUtil.isEmpty((Collection)((Collection)this.getData()))) {
            return false;
        }
        int numExamples = 0;
        this.weightedData = new ArrayList(((Collection)this.getData()).size());
        for (InputOutputPair example : (Collection)this.getData()) {
            if (example == null || example.getOutput() == null) continue;
            this.weightedData.add(DefaultWeightedInputOutputPair.create(example.getInput(), example.getOutput(), DatasetUtil.getWeight(example)));
            ++numExamples;
        }
        if (numExamples <= 0) {
            this.weightedData = null;
            return false;
        }
        Set<CategoryType> categories = DatasetUtil.findUniqueOutputs(this.weightedData);
        this.ensemble = new WeightedVotingCategorizerEnsemble(categories);
        return true;
    }

    @Override
    protected boolean step() {
        boolean correct;
        double weightSum = 0.0;
        for (DefaultWeightedInputOutputPair<InputType, CategoryType> example : this.weightedData) {
            weightSum += example.getWeight();
        }
        for (DefaultWeightedInputOutputPair<InputType, CategoryType> example : this.weightedData) {
            example.setWeight(example.getWeight() / weightSum);
        }
        Evaluator<InputType, CategoryType> member = this.getWeakLearner().learn(this.weightedData);
        double weightedErrorRate = 0.0;
        int dataSize = this.weightedData.size();
        boolean[] correctness = new boolean[dataSize];
        for (int i = 0; i < dataSize; ++i) {
            DefaultWeightedInputOutputPair<InputType, CategoryType> example = this.weightedData.get(i);
            Object actual = example.getOutput();
            Object predicted = member.evaluate(example.getInput());
            correctness[i] = correct = ObjectUtil.equalsSafe((Object)predicted, actual);
            if (correct) continue;
            weightedErrorRate += example.getWeight();
        }
        if (weightedErrorRate > 0.5) {
            return false;
        }
        double beta = weightedErrorRate / (1.0 - weightedErrorRate);
        for (int i = 0; i < dataSize; ++i) {
            DefaultWeightedInputOutputPair<InputType, CategoryType> example = this.weightedData.get(i);
            correct = correctness[i];
            double oldWeight = example.getWeight();
            double newWeight = oldWeight * Math.pow(beta, 1.0 - (correct ? 0.0 : 1.0));
            example.setWeight(newWeight);
        }
        double memberWeight = beta == 0.0 ? Double.POSITIVE_INFINITY : Math.log(1.0 / beta);
        this.ensemble.add(member, memberWeight);
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
        this.weightedData = null;
    }

    public WeightedVotingCategorizerEnsemble<InputType, CategoryType, Evaluator<? super InputType, ? extends CategoryType>> getResult() {
        return this.ensemble;
    }

    @Override
    public BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> getLearner() {
        return this.weakLearner;
    }

    public BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> getWeakLearner() {
        return this.weakLearner;
    }

    public void setWeakLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> weakLearner) {
        this.weakLearner = weakLearner;
    }

    public static void main(String ... args) {
        System.out.println(Math.log(1.0));
        System.out.println(Math.log(1.0E-8));
        System.out.println(Math.log(0.0));
        System.out.println(Math.pow(4.7, 1.0));
    }
}

