/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.cluster;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.GaussianCluster;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Created default constructor.", "Otherwise code looks fine."})
public class GaussianClusterCreator
extends AbstractCloneableSerializable
implements ClusterCreator<GaussianCluster, Vector> {
    public static final double DEFAULT_COVARIANCE = 1.0E-4;
    private double defaultCovariance;

    public GaussianClusterCreator() {
        this(1.0E-4);
    }

    public GaussianClusterCreator(double defaultCovariance) {
        this.setDefaultCovariance(defaultCovariance);
    }

    @Override
    public GaussianCluster createCluster(Collection<Vector> members) {
        MultivariateGaussian.PDF gaussian = MultivariateGaussian.MaximumLikelihoodEstimator.learn(members, this.getDefaultCovariance());
        return new GaussianCluster(members, gaussian);
    }

    public double getDefaultCovariance() {
        return this.defaultCovariance;
    }

    public void setDefaultCovariance(double defaultCovariance) {
        this.defaultCovariance = defaultCovariance;
    }
}

