/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering;

import gov.sandia.cognition.algorithm.ParallelAlgorithm;
import gov.sandia.cognition.algorithm.ParallelUtil;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.clustering.KMeansClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.ClusterDivergenceFunction;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.FixedClusterInitializer;
import gov.sandia.cognition.learning.data.SequentialDataMultiPartitioner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

@PublicationReference(author={"Halil Bisgin"}, title="Parallel Clustering Algorithms with Application to Climatology", type=PublicationType.Thesis, year=2007, url="http://www.halilbisgin.com/thesis/thesis.pdf")
public class ParallelizedKMeansClusterer<DataType, ClusterType extends Cluster<DataType>>
extends KMeansClusterer<DataType, ClusterType>
implements ParallelAlgorithm {
    private ArrayList<Callable<int[]>> assignmentTasks;
    private ArrayList<Callable<ClusterType>> clusterCreatorTask;
    private transient ThreadPoolExecutor threadPool;
    private Collection<int[]> assignmentList;
    private int[] newAssignments;

    public ParallelizedKMeansClusterer() {
        this(10, 1000, null, null, null, null);
    }

    public ParallelizedKMeansClusterer(int numRequestedClusters, int maxIterations, ThreadPoolExecutor threadPool, FixedClusterInitializer<ClusterType, DataType> initializer, ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator) {
        super(numRequestedClusters, maxIterations, initializer, divergenceFunction, creator);
        this.setThreadPool(threadPool);
    }

    @Override
    public ParallelizedKMeansClusterer<DataType, ClusterType> clone() {
        return (ParallelizedKMeansClusterer)super.clone();
    }

    public ThreadPoolExecutor getThreadPool() {
        if (this.threadPool == null) {
            this.setThreadPool(ParallelUtil.createThreadPool());
        }
        return this.threadPool;
    }

    public void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public int getNumThreads() {
        return ParallelUtil.getNumThreads((ParallelAlgorithm)this);
    }

    protected void createAssignmentTasks() {
        int numThreads = this.getNumThreads();
        ArrayList partitions = SequentialDataMultiPartitioner.create((Collection)this.getData(), numThreads);
        this.assignmentTasks = new ArrayList(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            this.assignmentTasks.add(new AssignDataToCluster(partitions.get(i)));
        }
        int numClusters = this.getNumClusters();
        this.clusterCreatorTask = new ArrayList(numClusters);
        for (int i = 0; i < numClusters; ++i) {
            this.clusterCreatorTask.add(new CreateClustersFromAssignments());
        }
    }

    @Override
    protected boolean initializeAlgorithm() {
        boolean superRetval = super.initializeAlgorithm();
        this.createAssignmentTasks();
        this.newAssignments = new int[((Collection)this.data).size()];
        return superRetval;
    }

    @Override
    protected int[] assignDataToClusters(Collection<? extends DataType> data) {
        try {
            this.assignmentList = ParallelUtil.executeInParallel(this.assignmentTasks, (ThreadPoolExecutor)this.getThreadPool());
        }
        catch (Exception ex) {
            Logger.getLogger(ParallelizedKMeansClusterer.class.getName()).log(Level.SEVERE, null, ex);
        }
        int index = 0;
        for (int[] subAssignment : this.assignmentList) {
            for (int i = 0; i < subAssignment.length; ++i) {
                int assignment;
                this.newAssignments[index] = assignment = subAssignment[i];
                ++index;
            }
        }
        return this.newAssignments;
    }

    @Override
    protected void createClustersFromAssignments() {
        int numClusters = this.getNumClusters();
        ArrayList clustersMembers = this.assignDataFromIndices();
        for (int i = 0; i < numClusters; ++i) {
            ((CreateClustersFromAssignments)this.clusterCreatorTask.get((int)i)).data = clustersMembers.get(i);
        }
        ArrayList results = null;
        try {
            results = ParallelUtil.executeInParallel(this.clusterCreatorTask, (ThreadPoolExecutor)this.getThreadPool());
        }
        catch (Exception ex) {
            Logger.getLogger(ParallelizedKMeansClusterer.class.getName()).log(Level.SEVERE, null, ex);
        }
        int index = 0;
        for (Cluster cluster : results) {
            this.getClusters().set(index, cluster);
            ++index;
        }
    }

    protected class AssignDataToCluster
    implements Callable<int[]> {
        private Collection<DataType> localData;

        public AssignDataToCluster(Collection<DataType> localData) {
            this.localData = localData;
        }

        @Override
        public int[] call() {
            return ParallelizedKMeansClusterer.super.assignDataToClusters(this.localData);
        }
    }

    protected class CreateClustersFromAssignments
    implements Callable<ClusterType> {
        public ArrayList<DataType> data = null;

        @Override
        public ClusterType call() {
            return ParallelizedKMeansClusterer.this.getCreator().createCluster(this.data);
        }
    }
}

