/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public strictfp class FloatFFT_2D {
    private int rows;
    private int columns;
    private float[] t;
    private FloatFFT_1D fftColumns;
    private FloatFFT_1D fftRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_2D(int rows, int columns) {
        if (rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = rows;
        this.columns = columns;
        if (rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 8 * this.oldNthreads * rows;
            if (2 * columns == 4 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (2 * columns < 4 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
        }
        this.fftRows = new FloatFFT_1D(rows);
        this.fftColumns = rows == columns ? this.fftRows : new FloatFFT_1D(columns);
    }

    public void complexForward(final float[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns = 2 * this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, a, true);
                this.cdft2d_subth(-1, a, true);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexForward(a, r * this.columns);
                }
                this.cdft2d_sub(-1, a, true);
            }
            this.columns = oldn2;
        } else {
            final int rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                FloatFFT_2D.this.fftColumns.complexForward(a, r * rowStride);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[2 * FloatFFT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int idx2;
                                int idx1;
                                int r;
                                int idx0 = 2 * c;
                                for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                    idx1 = 2 * r;
                                    idx2 = r * rowStride + idx0;
                                    temp[idx1] = a[idx2];
                                    temp[idx1 + 1] = a[idx2 + 1];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(temp);
                                for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                    idx1 = 2 * r;
                                    idx2 = r * rowStride + idx0;
                                    a[idx2] = temp[idx1];
                                    a[idx2 + 1] = temp[idx1 + 1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexForward(a, r * rowStride);
                }
                float[] temp = new float[2 * this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int idx2;
                    int idx1;
                    int r;
                    int idx0 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = 2 * r;
                        idx2 = r * rowStride + idx0;
                        temp[idx1] = a[idx2];
                        temp[idx1 + 1] = a[idx2 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = 2 * r;
                        idx2 = r * rowStride + idx0;
                        a[idx2] = temp[idx1];
                        a[idx2 + 1] = temp[idx1 + 1];
                    }
                }
            }
        }
    }

    public void complexForward(final float[][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns = 2 * this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, a, true);
                this.cdft2d_subth(-1, a, true);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexForward(a[r]);
                }
                this.cdft2d_sub(-1, a, true);
            }
            this.columns = oldn2;
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            FloatFFT_2D.this.fftColumns.complexForward(a[r]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = l * p;
                final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_2D.this.rows];
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idx2;
                            int r;
                            int idx1 = 2 * c;
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = 2 * r;
                                temp[idx2] = a[r][idx1];
                                temp[idx2 + 1] = a[r][idx1 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp);
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = 2 * r;
                                a[r][idx1] = temp[idx2];
                                a[r][idx1 + 1] = temp[idx2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.complexForward(a[r]);
            }
            float[] temp = new float[2 * this.rows];
            for (int c = 0; c < this.columns; ++c) {
                int idx2;
                int r;
                int idx1 = 2 * c;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    temp[idx2] = a[r][idx1];
                    temp[idx2 + 1] = a[r][idx1 + 1];
                }
                this.fftRows.complexForward(temp);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[r][idx1] = temp[idx2];
                    a[r][idx1 + 1] = temp[idx2 + 1];
                }
            }
        }
    }

    public void complexInverse(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns = 2 * this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, a, scale);
                this.cdft2d_subth(1, a, scale);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexInverse(a, r * this.columns, scale);
                }
                this.cdft2d_sub(1, a, scale);
            }
            this.columns = oldn2;
        } else {
            final int rowspan = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int r = firstRow; r < lastRow; ++r) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a, r * rowspan, scale);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[2 * FloatFFT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int idx3;
                                int idx2;
                                int r;
                                int idx1 = 2 * c;
                                for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = r * rowspan + idx1;
                                    temp[idx2] = a[idx3];
                                    temp[idx2 + 1] = a[idx3 + 1];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(temp, scale);
                                for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = r * rowspan + idx1;
                                    a[idx3] = temp[idx2];
                                    a[idx3 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexInverse(a, r * rowspan, scale);
                }
                float[] temp = new float[2 * this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int idx3;
                    int idx2;
                    int r;
                    int idx1 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = r * rowspan + idx1;
                        temp[idx2] = a[idx3];
                        temp[idx2 + 1] = a[idx3 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = r * rowspan + idx1;
                        a[idx3] = temp[idx2];
                        a[idx3 + 1] = temp[idx2 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final float[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns = 2 * this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, a, scale);
                this.cdft2d_subth(1, a, scale);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexInverse(a[r], scale);
                }
                this.cdft2d_sub(1, a, scale);
            }
            this.columns = oldn2;
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            FloatFFT_2D.this.fftColumns.complexInverse(a[r], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = l * p;
                final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[2 * FloatFFT_2D.this.rows];
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idx2;
                            int r;
                            int idx1 = 2 * c;
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = 2 * r;
                                temp[idx2] = a[r][idx1];
                                temp[idx2 + 1] = a[r][idx1 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp, scale);
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = 2 * r;
                                a[r][idx1] = temp[idx2];
                                a[r][idx1 + 1] = temp[idx2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.complexInverse(a[r], scale);
            }
            float[] temp = new float[2 * this.rows];
            for (int c = 0; c < this.columns; ++c) {
                int idx2;
                int r;
                int idx1 = 2 * c;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    temp[idx2] = a[r][idx1];
                    temp[idx2 + 1] = a[r][idx1 + 1];
                }
                this.fftRows.complexInverse(temp, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[r][idx1] = temp[idx2];
                    a[r][idx1 + 1] = temp[idx2 + 1];
                }
            }
        }
    }

    public void realForward(float[] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = 8 * nthreads * this.rows;
            if (this.columns == 4 * nthreads) {
                this.nt >>= 1;
            } else if (this.columns < 4 * nthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, a, true);
            this.cdft2d_subth(-1, a, true);
            this.rdft2d_sub(1, a);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.realForward(a, r * this.columns);
            }
            this.cdft2d_sub(-1, a, true);
            this.rdft2d_sub(1, a);
        }
    }

    public void realForward(float[][] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = 8 * nthreads * this.rows;
            if (this.columns == 4 * nthreads) {
                this.nt >>= 1;
            } else if (this.columns < 4 * nthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, a, true);
            this.cdft2d_subth(-1, a, true);
            this.rdft2d_sub(1, a);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.realForward(a[r]);
            }
            this.cdft2d_sub(-1, a, true);
            this.rdft2d_sub(1, a);
        }
    }

    public void realForwardFull(float[] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, a, true);
                this.cdft2d_subth(-1, a, true);
                this.rdft2d_sub(1, a);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.realForward(a, r * this.columns);
                }
                this.cdft2d_sub(-1, a, true);
                this.rdft2d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realForwardFull(float[][] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, a, true);
                this.cdft2d_subth(-1, a, true);
                this.rdft2d_sub(1, a);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.realForward(a[r]);
                }
                this.cdft2d_sub(-1, a, true);
                this.rdft2d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realInverse(float[] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = 8 * nthreads * this.rows;
            if (this.columns == 4 * nthreads) {
                this.nt >>= 1;
            } else if (this.columns < 4 * nthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.rdft2d_sub(-1, a);
            this.cdft2d_subth(1, a, scale);
            this.xdft2d0_subth1(1, -1, a, scale);
        } else {
            this.rdft2d_sub(-1, a);
            this.cdft2d_sub(1, a, scale);
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.realInverse(a, r * this.columns, scale);
            }
        }
    }

    public void realInverse(float[][] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = 8 * nthreads * this.rows;
            if (this.columns == 4 * nthreads) {
                this.nt >>= 1;
            } else if (this.columns < 4 * nthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.rdft2d_sub(-1, a);
            this.cdft2d_subth(1, a, scale);
            this.xdft2d0_subth1(1, -1, a, scale);
        } else {
            this.rdft2d_sub(-1, a);
            this.cdft2d_sub(1, a, scale);
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.realInverse(a[r], scale);
            }
        }
    }

    public void realInverseFull(float[] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, a, scale);
                this.cdft2d_subth(1, a, scale);
                this.rdft2d_sub(1, a);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.realInverse2(a, r * this.columns, scale);
                }
                this.cdft2d_sub(1, a, scale);
                this.rdft2d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    public void realInverseFull(float[][] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = 8 * nthreads * this.rows;
                if (this.columns == 4 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, a, scale);
                this.cdft2d_subth(1, a, scale);
                this.rdft2d_sub(1, a);
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.realInverse2(a[r], 0, scale);
                }
                this.cdft2d_sub(1, a, scale);
                this.rdft2d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    private void mixedRadixRealForwardFull(final float[][] a) {
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int r;
            int lastRow;
            int firstRow;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstRow = l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstRow; i < lastRow; ++i) {
                            FloatFFT_2D.this.fftColumns.realForward(a[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (r = 0; r < this.rows; ++r) {
                temp[0][r] = a[r][0];
            }
            this.fftRows.realForwardFull(temp[0]);
            p = (n2d2 - 2) / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = 1 + l * p;
                final int lastColumn = l == nthreads - 1 ? n2d2 - 1 : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idx2 = 2 * c;
                            for (int r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                int idx1 = 2 * r;
                                temp[c][idx1] = a[r][idx2];
                                temp[c][idx1 + 1] = a[r][idx2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp[c]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            if (this.columns % 2 == 0) {
                for (r = 0; r < this.rows; ++r) {
                    temp[n2d2 - 1][r] = a[r][1];
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                for (r = 0; r < this.rows; ++r) {
                    int idx1 = 2 * r;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a[r][2 * idx2];
                    temp[idx2][idx1 + 1] = a[r][1];
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstRow = l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = 2 * r;
                            for (int c = 0; c < n2d2; ++c) {
                                int idx2 = 2 * c;
                                a[r][idx2] = temp[c][idx1];
                                a[r][idx2 + 1] = temp[c][idx1 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstRow = 1 + l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx3 = FloatFFT_2D.this.rows - r;
                            for (int c = n2d2; c < FloatFFT_2D.this.columns; ++c) {
                                int idx1 = 2 * c;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c);
                                a[0][idx1] = a[0][idx2];
                                a[0][idx1 + 1] = -a[0][idx2 + 1];
                                a[r][idx1] = a[idx3][idx2];
                                a[r][idx1 + 1] = -a[idx3][idx2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int idx1;
            int idx12;
            int r;
            for (r = 0; r < this.rows; ++r) {
                this.fftColumns.realForward(a[r]);
            }
            for (r = 0; r < this.rows; ++r) {
                temp[0][r] = a[r][0];
            }
            this.fftRows.realForwardFull(temp[0]);
            for (int c2 = 1; c2 < n2d2 - 1; ++c2) {
                int idx2 = 2 * c2;
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    idx12 = 2 * r2;
                    temp[c2][idx12] = a[r2][idx2];
                    temp[c2][idx12 + 1] = a[r2][idx2 + 1];
                }
                this.fftRows.complexForward(temp[c2]);
            }
            if (this.columns % 2 == 0) {
                for (r = 0; r < this.rows; ++r) {
                    temp[n2d2 - 1][r] = a[r][1];
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                for (r = 0; r < this.rows; ++r) {
                    idx1 = 2 * r;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a[r][2 * idx2];
                    temp[idx2][idx1 + 1] = a[r][1];
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = 2 * r;
                for (c = 0; c < n2d2; ++c) {
                    int idx2 = 2 * c;
                    a[r][idx2] = temp[c][idx1];
                    a[r][idx2 + 1] = temp[c][idx1 + 1];
                }
            }
            for (r = 1; r < this.rows; ++r) {
                int idx3 = this.rows - r;
                for (c = n2d2; c < this.columns; ++c) {
                    idx12 = 2 * c;
                    int idx2 = 2 * (this.columns - c);
                    a[0][idx12] = a[0][idx2];
                    a[0][idx12 + 1] = -a[0][idx2 + 1];
                    a[r][idx12] = a[idx3][idx2];
                    a[r][idx12 + 1] = -a[idx3][idx2 + 1];
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] a) {
        final int rowStride = 2 * this.columns;
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int r;
            int lastRow;
            int firstRow;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstRow = l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstRow; i < lastRow; ++i) {
                            FloatFFT_2D.this.fftColumns.realForward(a, i * FloatFFT_2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (r = 0; r < this.rows; ++r) {
                temp[0][r] = a[r * this.columns];
            }
            this.fftRows.realForwardFull(temp[0]);
            p = (n2d2 - 2) / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = 1 + l * p;
                final int lastColumn = l == nthreads - 1 ? n2d2 - 1 : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idx0 = 2 * c;
                            for (int r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                int idx1 = 2 * r;
                                int idx2 = r * FloatFFT_2D.this.columns + idx0;
                                temp[c][idx1] = a[idx2];
                                temp[c][idx1 + 1] = a[idx2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(temp[c]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            if (this.columns % 2 == 0) {
                for (r = 0; r < this.rows; ++r) {
                    temp[n2d2 - 1][r] = a[r * this.columns + 1];
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                for (r = 0; r < this.rows; ++r) {
                    int idx1 = 2 * r;
                    int idx2 = r * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a[idx2 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a[idx2 + 1];
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstRow = l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = 2 * r;
                            for (int c = 0; c < n2d2; ++c) {
                                int idx0 = 2 * c;
                                int idx2 = r * rowStride + idx0;
                                a[idx2] = temp[c][idx1];
                                a[idx2 + 1] = temp[c][idx1 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstRow = 1 + l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx5 = r * rowStride;
                            int idx6 = (FloatFFT_2D.this.rows - r + 1) * rowStride;
                            for (int c = n2d2; c < FloatFFT_2D.this.columns; ++c) {
                                int idx1 = 2 * c;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c);
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                                int idx3 = idx5 + idx1;
                                int idx4 = idx6 - idx1;
                                a[idx3] = a[idx4];
                                a[idx3 + 1] = -a[idx4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx1;
            int idx2;
            int r;
            for (r = 0; r < this.rows; ++r) {
                this.fftColumns.realForward(a, r * this.columns);
            }
            for (r = 0; r < this.rows; ++r) {
                temp[0][r] = a[r * this.columns];
            }
            this.fftRows.realForwardFull(temp[0]);
            for (int c = 1; c < n2d2 - 1; ++c) {
                int idx0 = 2 * c;
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    int idx12 = 2 * r2;
                    idx2 = r2 * this.columns + idx0;
                    temp[c][idx12] = a[idx2];
                    temp[c][idx12 + 1] = a[idx2 + 1];
                }
                this.fftRows.complexForward(temp[c]);
            }
            if (this.columns % 2 == 0) {
                for (r = 0; r < this.rows; ++r) {
                    temp[n2d2 - 1][r] = a[r * this.columns + 1];
                }
                this.fftRows.realForwardFull(temp[n2d2 - 1]);
            } else {
                for (r = 0; r < this.rows; ++r) {
                    idx1 = 2 * r;
                    int idx22 = r * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a[idx22 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a[idx22 + 1];
                }
                this.fftRows.complexForward(temp[n2d2 - 1]);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = 2 * r;
                for (int c = 0; c < n2d2; ++c) {
                    int idx0 = 2 * c;
                    idx2 = r * rowStride + idx0;
                    a[idx2] = temp[c][idx1];
                    a[idx2 + 1] = temp[c][idx1 + 1];
                }
            }
            for (r = 1; r < this.rows; ++r) {
                int idx5 = r * rowStride;
                int idx6 = (this.rows - r + 1) * rowStride;
                for (int c = n2d2; c < this.columns; ++c) {
                    int idx13 = 2 * c;
                    int idx23 = 2 * (this.columns - c);
                    a[idx13] = a[idx23];
                    a[idx13 + 1] = -a[idx23 + 1];
                    int idx3 = idx5 + idx13;
                    int idx4 = idx6 - idx13;
                    a[idx3] = a[idx4];
                    a[idx3 + 1] = -a[idx4 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][] a, final boolean scale) {
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int r;
            int lastRow;
            int firstRow;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstRow = l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstRow; i < lastRow; ++i) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a[i], 0, scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (r = 0; r < this.rows; ++r) {
                temp[0][r] = a[r][0];
            }
            this.fftRows.realInverseFull(temp[0], scale);
            p = (n2d2 - 2) / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = 1 + l * p;
                final int lastColumn = l == nthreads - 1 ? n2d2 - 1 : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idx2 = 2 * c;
                            for (int r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                int idx1 = 2 * r;
                                temp[c][idx1] = a[r][idx2];
                                temp[c][idx1 + 1] = a[r][idx2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp[c], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            if (this.columns % 2 == 0) {
                for (r = 0; r < this.rows; ++r) {
                    temp[n2d2 - 1][r] = a[r][1];
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                for (r = 0; r < this.rows; ++r) {
                    int idx1 = 2 * r;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a[r][2 * idx2];
                    temp[idx2][idx1 + 1] = a[r][1];
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstRow = l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = 2 * r;
                            for (int c = 0; c < n2d2; ++c) {
                                int idx2 = 2 * c;
                                a[r][idx2] = temp[c][idx1];
                                a[r][idx2 + 1] = temp[c][idx1 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstRow = 1 + l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx3 = FloatFFT_2D.this.rows - r;
                            for (int c = n2d2; c < FloatFFT_2D.this.columns; ++c) {
                                int idx1 = 2 * c;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c);
                                a[0][idx1] = a[0][idx2];
                                a[0][idx1 + 1] = -a[0][idx2 + 1];
                                a[r][idx1] = a[idx3][idx2];
                                a[r][idx1 + 1] = -a[idx3][idx2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int idx1;
            int idx12;
            int r;
            for (r = 0; r < this.rows; ++r) {
                this.fftColumns.realInverse2(a[r], 0, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                temp[0][r] = a[r][0];
            }
            this.fftRows.realInverseFull(temp[0], scale);
            for (int c2 = 1; c2 < n2d2 - 1; ++c2) {
                int idx2 = 2 * c2;
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    idx12 = 2 * r2;
                    temp[c2][idx12] = a[r2][idx2];
                    temp[c2][idx12 + 1] = a[r2][idx2 + 1];
                }
                this.fftRows.complexInverse(temp[c2], scale);
            }
            if (this.columns % 2 == 0) {
                for (r = 0; r < this.rows; ++r) {
                    temp[n2d2 - 1][r] = a[r][1];
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                for (r = 0; r < this.rows; ++r) {
                    idx1 = 2 * r;
                    int idx2 = n2d2 - 1;
                    temp[idx2][idx1] = a[r][2 * idx2];
                    temp[idx2][idx1 + 1] = a[r][1];
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = 2 * r;
                for (c = 0; c < n2d2; ++c) {
                    int idx2 = 2 * c;
                    a[r][idx2] = temp[c][idx1];
                    a[r][idx2 + 1] = temp[c][idx1 + 1];
                }
            }
            for (r = 1; r < this.rows; ++r) {
                int idx3 = this.rows - r;
                for (c = n2d2; c < this.columns; ++c) {
                    idx12 = 2 * c;
                    int idx2 = 2 * (this.columns - c);
                    a[0][idx12] = a[0][idx2];
                    a[0][idx12 + 1] = -a[0][idx2 + 1];
                    a[r][idx12] = a[idx3][idx2];
                    a[r][idx12 + 1] = -a[idx3][idx2 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] a, final boolean scale) {
        final int rowStride = 2 * this.columns;
        final int n2d2 = this.columns / 2 + 1;
        final float[][] temp = new float[n2d2][2 * this.rows];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.rows >= nthreads && n2d2 - 2 >= nthreads) {
            int r;
            int lastRow;
            int firstRow;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstRow = l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstRow; i < lastRow; ++i) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a, i * FloatFFT_2D.this.columns, scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (r = 0; r < this.rows; ++r) {
                temp[0][r] = a[r * this.columns];
            }
            this.fftRows.realInverseFull(temp[0], scale);
            p = (n2d2 - 2) / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = 1 + l * p;
                final int lastColumn = l == nthreads - 1 ? n2d2 - 1 : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int idx0 = 2 * c;
                            for (int r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                int idx1 = 2 * r;
                                int idx2 = r * FloatFFT_2D.this.columns + idx0;
                                temp[c][idx1] = a[idx2];
                                temp[c][idx1 + 1] = a[idx2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(temp[c], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            if (this.columns % 2 == 0) {
                for (r = 0; r < this.rows; ++r) {
                    temp[n2d2 - 1][r] = a[r * this.columns + 1];
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                for (r = 0; r < this.rows; ++r) {
                    int idx1 = 2 * r;
                    int idx2 = r * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a[idx2 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a[idx2 + 1];
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstRow = l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = 2 * r;
                            for (int c = 0; c < n2d2; ++c) {
                                int idx0 = 2 * c;
                                int idx2 = r * rowStride + idx0;
                                a[idx2] = temp[c][idx1];
                                a[idx2 + 1] = temp[c][idx1 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstRow = 1 + l * p;
                lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx5 = r * rowStride;
                            int idx6 = (FloatFFT_2D.this.rows - r + 1) * rowStride;
                            for (int c = n2d2; c < FloatFFT_2D.this.columns; ++c) {
                                int idx1 = 2 * c;
                                int idx2 = 2 * (FloatFFT_2D.this.columns - c);
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                                int idx3 = idx5 + idx1;
                                int idx4 = idx6 - idx1;
                                a[idx3] = a[idx4];
                                a[idx3 + 1] = -a[idx4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx1;
            int idx2;
            int r;
            for (r = 0; r < this.rows; ++r) {
                this.fftColumns.realInverse2(a, r * this.columns, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                temp[0][r] = a[r * this.columns];
            }
            this.fftRows.realInverseFull(temp[0], scale);
            for (int c = 1; c < n2d2 - 1; ++c) {
                int idx0 = 2 * c;
                for (int r2 = 0; r2 < this.rows; ++r2) {
                    int idx12 = 2 * r2;
                    idx2 = r2 * this.columns + idx0;
                    temp[c][idx12] = a[idx2];
                    temp[c][idx12 + 1] = a[idx2 + 1];
                }
                this.fftRows.complexInverse(temp[c], scale);
            }
            if (this.columns % 2 == 0) {
                for (r = 0; r < this.rows; ++r) {
                    temp[n2d2 - 1][r] = a[r * this.columns + 1];
                }
                this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
            } else {
                for (r = 0; r < this.rows; ++r) {
                    idx1 = 2 * r;
                    int idx22 = r * this.columns;
                    int idx3 = n2d2 - 1;
                    temp[idx3][idx1] = a[idx22 + 2 * idx3];
                    temp[idx3][idx1 + 1] = a[idx22 + 1];
                }
                this.fftRows.complexInverse(temp[n2d2 - 1], scale);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = 2 * r;
                for (int c = 0; c < n2d2; ++c) {
                    int idx0 = 2 * c;
                    idx2 = r * rowStride + idx0;
                    a[idx2] = temp[c][idx1];
                    a[idx2 + 1] = temp[c][idx1 + 1];
                }
            }
            for (r = 1; r < this.rows; ++r) {
                int idx5 = r * rowStride;
                int idx6 = (this.rows - r + 1) * rowStride;
                for (int c = n2d2; c < this.columns; ++c) {
                    int idx13 = 2 * c;
                    int idx23 = 2 * (this.columns - c);
                    a[idx13] = a[idx23];
                    a[idx13 + 1] = -a[idx23 + 1];
                    int idx3 = idx5 + idx13;
                    int idx4 = idx6 - idx13;
                    a[idx3] = a[idx4];
                    a[idx3 + 1] = -a[idx4 + 1];
                }
            }
        }
    }

    private void rdft2d_sub(int isgn, float[] a) {
        int n1h = this.rows >> 1;
        if (isgn < 0) {
            for (int i = 1; i < n1h; ++i) {
                int j = this.rows - i;
                int idx1 = i * this.columns;
                int idx2 = j * this.columns;
                float xi = a[idx1] - a[idx2];
                int n = idx1;
                a[n] = a[n] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n2 = idx1 + 1;
                a[n2] = a[n2] + a[idx2 + 1];
                a[idx2 + 1] = xi;
            }
        } else {
            for (int i = 1; i < n1h; ++i) {
                int j = this.rows - i;
                int idx1 = i * this.columns;
                int idx2 = j * this.columns;
                a[idx2] = 0.5f * (a[idx1] - a[idx2]);
                int n = idx1;
                a[n] = a[n] - a[idx2];
                a[idx2 + 1] = 0.5f * (a[idx1 + 1] + a[idx2 + 1]);
                int n3 = idx1 + 1;
                a[n3] = a[n3] - a[idx2 + 1];
            }
        }
    }

    private void rdft2d_sub(int isgn, float[][] a) {
        int n1h = this.rows >> 1;
        if (isgn < 0) {
            for (int i = 1; i < n1h; ++i) {
                int j = this.rows - i;
                float xi = a[i][0] - a[j][0];
                float[] fArray = a[i];
                fArray[0] = fArray[0] + a[j][0];
                a[j][0] = xi;
                xi = a[j][1] - a[i][1];
                float[] fArray2 = a[i];
                fArray2[1] = fArray2[1] + a[j][1];
                a[j][1] = xi;
            }
        } else {
            for (int i = 1; i < n1h; ++i) {
                int j = this.rows - i;
                a[j][0] = 0.5f * (a[i][0] - a[j][0]);
                float[] fArray = a[i];
                fArray[0] = fArray[0] - a[j][0];
                a[j][1] = 0.5f * (a[i][1] + a[j][1]);
                float[] fArray3 = a[i];
                fArray3[1] = fArray3[1] - a[j][1];
            }
        }
    }

    private void cdft2d_sub(int isgn, float[] a, boolean scale) {
        block21: {
            block19: {
                int idx2;
                int idx1;
                int r;
                block22: {
                    int idx3;
                    int idx22;
                    int idx12;
                    int r2;
                    block20: {
                        if (isgn != -1) break block19;
                        if (this.columns <= 4) break block20;
                        for (int c = 0; c < this.columns; c += 8) {
                            int idx5;
                            int idx4;
                            int idx32;
                            int idx23;
                            int idx13;
                            int r3;
                            for (r3 = 0; r3 < this.rows; ++r3) {
                                idx13 = r3 * this.columns + c;
                                idx23 = 2 * r3;
                                idx32 = 2 * this.rows + 2 * r3;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                this.t[idx23] = a[idx13];
                                this.t[idx23 + 1] = a[idx13 + 1];
                                this.t[idx32] = a[idx13 + 2];
                                this.t[idx32 + 1] = a[idx13 + 3];
                                this.t[idx4] = a[idx13 + 4];
                                this.t[idx4 + 1] = a[idx13 + 5];
                                this.t[idx5] = a[idx13 + 6];
                                this.t[idx5 + 1] = a[idx13 + 7];
                            }
                            this.fftRows.complexForward(this.t, 0);
                            this.fftRows.complexForward(this.t, 2 * this.rows);
                            this.fftRows.complexForward(this.t, 4 * this.rows);
                            this.fftRows.complexForward(this.t, 6 * this.rows);
                            for (r3 = 0; r3 < this.rows; ++r3) {
                                idx13 = r3 * this.columns + c;
                                idx23 = 2 * r3;
                                idx32 = 2 * this.rows + 2 * r3;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                a[idx13] = this.t[idx23];
                                a[idx13 + 1] = this.t[idx23 + 1];
                                a[idx13 + 2] = this.t[idx32];
                                a[idx13 + 3] = this.t[idx32 + 1];
                                a[idx13 + 4] = this.t[idx4];
                                a[idx13 + 5] = this.t[idx4 + 1];
                                a[idx13 + 6] = this.t[idx5];
                                a[idx13 + 7] = this.t[idx5 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.columns != 4) break block22;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx12 = r2 * this.columns;
                        idx22 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        this.t[idx22] = a[idx12];
                        this.t[idx22 + 1] = a[idx12 + 1];
                        this.t[idx3] = a[idx12 + 2];
                        this.t[idx3 + 1] = a[idx12 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx12 = r2 * this.columns;
                        idx22 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        a[idx12] = this.t[idx22];
                        a[idx12 + 1] = this.t[idx22 + 1];
                        a[idx12 + 2] = this.t[idx3];
                        a[idx12 + 3] = this.t[idx3 + 1];
                    }
                    break block21;
                }
                if (this.columns != 2) break block21;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                }
                break block21;
            }
            if (this.columns > 4) {
                for (int c = 0; c < this.columns; c += 8) {
                    int idx5;
                    int idx4;
                    int idx3;
                    int idx2;
                    int idx1;
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = r * this.columns + c;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                        this.t[idx4] = a[idx1 + 4];
                        this.t[idx4 + 1] = a[idx1 + 5];
                        this.t[idx5] = a[idx1 + 6];
                        this.t[idx5 + 1] = a[idx1 + 7];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = r * this.columns + c;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                        a[idx1 + 4] = this.t[idx4];
                        a[idx1 + 5] = this.t[idx4 + 1];
                        a[idx1 + 6] = this.t[idx5];
                        a[idx1 + 7] = this.t[idx5 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                    this.t[idx3] = a[idx1 + 2];
                    this.t[idx3 + 1] = a[idx1 + 3];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                    a[idx1 + 2] = this.t[idx3];
                    a[idx1 + 3] = this.t[idx3 + 1];
                }
            } else if (this.columns == 2) {
                int idx2;
                int idx1;
                int r;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                }
            }
        }
    }

    private void cdft2d_sub(int isgn, float[][] a, boolean scale) {
        block21: {
            block19: {
                int idx2;
                int r;
                block22: {
                    int idx3;
                    int idx22;
                    int r2;
                    block20: {
                        if (isgn != -1) break block19;
                        if (this.columns <= 4) break block20;
                        for (int c = 0; c < this.columns; c += 8) {
                            int idx5;
                            int idx4;
                            int idx32;
                            int idx23;
                            int r3;
                            for (r3 = 0; r3 < this.rows; ++r3) {
                                idx23 = 2 * r3;
                                idx32 = 2 * this.rows + 2 * r3;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                this.t[idx23] = a[r3][c];
                                this.t[idx23 + 1] = a[r3][c + 1];
                                this.t[idx32] = a[r3][c + 2];
                                this.t[idx32 + 1] = a[r3][c + 3];
                                this.t[idx4] = a[r3][c + 4];
                                this.t[idx4 + 1] = a[r3][c + 5];
                                this.t[idx5] = a[r3][c + 6];
                                this.t[idx5 + 1] = a[r3][c + 7];
                            }
                            this.fftRows.complexForward(this.t, 0);
                            this.fftRows.complexForward(this.t, 2 * this.rows);
                            this.fftRows.complexForward(this.t, 4 * this.rows);
                            this.fftRows.complexForward(this.t, 6 * this.rows);
                            for (r3 = 0; r3 < this.rows; ++r3) {
                                idx23 = 2 * r3;
                                idx32 = 2 * this.rows + 2 * r3;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                a[r3][c] = this.t[idx23];
                                a[r3][c + 1] = this.t[idx23 + 1];
                                a[r3][c + 2] = this.t[idx32];
                                a[r3][c + 3] = this.t[idx32 + 1];
                                a[r3][c + 4] = this.t[idx4];
                                a[r3][c + 5] = this.t[idx4 + 1];
                                a[r3][c + 6] = this.t[idx5];
                                a[r3][c + 7] = this.t[idx5 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.columns != 4) break block22;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx22 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        this.t[idx22] = a[r2][0];
                        this.t[idx22 + 1] = a[r2][1];
                        this.t[idx3] = a[r2][2];
                        this.t[idx3 + 1] = a[r2][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx22 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        a[r2][0] = this.t[idx22];
                        a[r2][1] = this.t[idx22 + 1];
                        a[r2][2] = this.t[idx3];
                        a[r2][3] = this.t[idx3 + 1];
                    }
                    break block21;
                }
                if (this.columns != 2) break block21;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                }
                break block21;
            }
            if (this.columns > 4) {
                for (int c = 0; c < this.columns; c += 8) {
                    int idx5;
                    int idx4;
                    int idx3;
                    int idx2;
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        this.t[idx2] = a[r][c];
                        this.t[idx2 + 1] = a[r][c + 1];
                        this.t[idx3] = a[r][c + 2];
                        this.t[idx3 + 1] = a[r][c + 3];
                        this.t[idx4] = a[r][c + 4];
                        this.t[idx4 + 1] = a[r][c + 5];
                        this.t[idx5] = a[r][c + 6];
                        this.t[idx5 + 1] = a[r][c + 7];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        a[r][c] = this.t[idx2];
                        a[r][c + 1] = this.t[idx2 + 1];
                        a[r][c + 2] = this.t[idx3];
                        a[r][c + 3] = this.t[idx3 + 1];
                        a[r][c + 4] = this.t[idx4];
                        a[r][c + 5] = this.t[idx4 + 1];
                        a[r][c + 6] = this.t[idx5];
                        a[r][c + 7] = this.t[idx5 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int idx3;
                int idx2;
                int r;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                    this.t[idx3] = a[r][2];
                    this.t[idx3 + 1] = a[r][3];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                    a[r][2] = this.t[idx3];
                    a[r][3] = this.t[idx3 + 1];
                }
            } else if (this.columns == 2) {
                int idx2;
                int r;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                }
            }
        }
    }

    private void xdft2d0_subth1(final int icr, final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a, r * FloatFFT_2D.this.columns);
                            }
                        } else {
                            for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a, r * FloatFFT_2D.this.columns, scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a, r * FloatFFT_2D.this.columns);
                        }
                    } else {
                        for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse(a, r * FloatFFT_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft2d0_subth2(final int icr, final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a, r * FloatFFT_2D.this.columns);
                            }
                        } else {
                            for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a, r * FloatFFT_2D.this.columns, scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a, r * FloatFFT_2D.this.columns);
                        }
                    } else {
                        for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a, r * FloatFFT_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft2d0_subth1(final int icr, final int isgn, final float[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a[r]);
                            }
                        } else {
                            for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a[r], scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a[r]);
                        }
                    } else {
                        for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse(a[r], scale);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft2d0_subth2(final int icr, final int isgn, final float[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (icr == 0) {
                        if (isgn == -1) {
                            for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexForward(a[r]);
                            }
                        } else {
                            for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                                FloatFFT_2D.this.fftColumns.complexInverse(a[r], scale);
                            }
                        }
                    } else if (isgn == 1) {
                        for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                            FloatFFT_2D.this.fftColumns.realForward(a[r]);
                        }
                    } else {
                        for (int r = n0; r < FloatFFT_2D.this.rows; r += nthreads) {
                            FloatFFT_2D.this.fftColumns.realInverse2(a[r], 0, scale);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void cdft2d_subth(final int isgn, final float[] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 8 * this.rows;
        if (this.columns == 4 * nthread) {
            nt >>= 1;
        } else if (this.columns < 4 * nthread) {
            nthread = this.columns >> 1;
            nt >>= 2;
        }
        Future[] futures = new Future[nthread];
        final int nthreads = nthread;
        for (int i = 0; i < nthread; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        block19: {
                            int idx2;
                            int idx1;
                            int r;
                            block22: {
                                int idx3;
                                int idx22;
                                int idx12;
                                int r2;
                                block20: {
                                    if (isgn != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * nthreads) break block20;
                                    for (int c = 8 * n0; c < FloatFFT_2D.this.columns; c += 8 * nthreads) {
                                        int idx5;
                                        int idx4;
                                        int idx32;
                                        int idx23;
                                        int idx13;
                                        int r3;
                                        for (r3 = 0; r3 < FloatFFT_2D.this.rows; ++r3) {
                                            idx13 = r3 * FloatFFT_2D.this.columns + c;
                                            idx23 = startt + 2 * r3;
                                            idx32 = startt + 2 * FloatFFT_2D.this.rows + 2 * r3;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx23] = a[idx13];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx23 + 1] = a[idx13 + 1];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx32] = a[idx13 + 2];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx32 + 1] = a[idx13 + 3];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx4] = a[idx13 + 4];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx4 + 1] = a[idx13 + 5];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx5] = a[idx13 + 6];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx5 + 1] = a[idx13 + 7];
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 6 * FloatFFT_2D.this.rows);
                                        for (r3 = 0; r3 < FloatFFT_2D.this.rows; ++r3) {
                                            idx13 = r3 * FloatFFT_2D.this.columns + c;
                                            idx23 = startt + 2 * r3;
                                            idx32 = startt + 2 * FloatFFT_2D.this.rows + 2 * r3;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            a[idx13] = FloatFFT_2D.this.t[idx23];
                                            a[idx13 + 1] = FloatFFT_2D.this.t[idx23 + 1];
                                            a[idx13 + 2] = FloatFFT_2D.this.t[idx32];
                                            a[idx13 + 3] = FloatFFT_2D.this.t[idx32 + 1];
                                            a[idx13 + 4] = FloatFFT_2D.this.t[idx4];
                                            a[idx13 + 5] = FloatFFT_2D.this.t[idx4 + 1];
                                            a[idx13 + 6] = FloatFFT_2D.this.t[idx5];
                                            a[idx13 + 7] = FloatFFT_2D.this.t[idx5 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * nthreads) break block22;
                                for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                    idx12 = r2 * FloatFFT_2D.this.columns + 4 * n0;
                                    idx22 = startt + 2 * r2;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r2;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx22] = a[idx12];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx22 + 1] = a[idx12 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[idx12 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[idx12 + 3];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows);
                                for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                    idx12 = r2 * FloatFFT_2D.this.columns + 4 * n0;
                                    idx22 = startt + 2 * r2;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r2;
                                    a[idx12] = FloatFFT_2D.this.t[idx22];
                                    a[idx12 + 1] = FloatFFT_2D.this.t[idx22 + 1];
                                    a[idx12 + 2] = FloatFFT_2D.this.t[idx3];
                                    a[idx12 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * nthreads) break block21;
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx1 = r * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = startt + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[idx1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[idx1 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx1 = r * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = startt + 2 * r;
                                a[idx1] = FloatFFT_2D.this.t[idx2];
                                a[idx1 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * nthreads) {
                            for (int c = 8 * n0; c < FloatFFT_2D.this.columns; c += 8 * nthreads) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int idx1;
                                int r;
                                for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                    idx1 = r * FloatFFT_2D.this.columns + c;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[idx1 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[idx1 + 3];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx4] = a[idx1 + 4];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx4 + 1] = a[idx1 + 5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx5] = a[idx1 + 6];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx5 + 1] = a[idx1 + 7];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 4 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 6 * FloatFFT_2D.this.rows, scale);
                                for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                    idx1 = r * FloatFFT_2D.this.columns + c;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    a[idx1] = FloatFFT_2D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                    a[idx1 + 2] = FloatFFT_2D.this.t[idx3];
                                    a[idx1 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                    a[idx1 + 4] = FloatFFT_2D.this.t[idx4];
                                    a[idx1 + 5] = FloatFFT_2D.this.t[idx4 + 1];
                                    a[idx1 + 6] = FloatFFT_2D.this.t[idx5];
                                    a[idx1 + 7] = FloatFFT_2D.this.t[idx5 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx1 = r * FloatFFT_2D.this.columns + 4 * n0;
                                idx2 = startt + 2 * r;
                                idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[idx1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[idx1 + 1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[idx1 + 2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[idx1 + 3];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows, scale);
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx1 = r * FloatFFT_2D.this.columns + 4 * n0;
                                idx2 = startt + 2 * r;
                                idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                a[idx1] = FloatFFT_2D.this.t[idx2];
                                a[idx1 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                a[idx1 + 2] = FloatFFT_2D.this.t[idx3];
                                a[idx1 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * nthreads) {
                            int idx2;
                            int idx1;
                            int r;
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx1 = r * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = startt + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[idx1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[idx1 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx1 = r * FloatFFT_2D.this.columns + 2 * n0;
                                idx2 = startt + 2 * r;
                                a[idx1] = FloatFFT_2D.this.t[idx2];
                                a[idx1 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void cdft2d_subth(final int isgn, final float[][] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 8 * this.rows;
        if (this.columns == 4 * nthread) {
            nt >>= 1;
        } else if (this.columns < 4 * nthread) {
            nthread = this.columns >> 1;
            nt >>= 2;
        }
        Future[] futures = new Future[nthread];
        final int nthreads = nthread;
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        block19: {
                            int idx2;
                            int r;
                            block22: {
                                int idx3;
                                int idx22;
                                int r2;
                                block20: {
                                    if (isgn != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * nthreads) break block20;
                                    for (int c = 8 * n0; c < FloatFFT_2D.this.columns; c += 8 * nthreads) {
                                        int idx5;
                                        int idx4;
                                        int idx32;
                                        int idx23;
                                        int r3;
                                        for (r3 = 0; r3 < FloatFFT_2D.this.rows; ++r3) {
                                            idx23 = startt + 2 * r3;
                                            idx32 = startt + 2 * FloatFFT_2D.this.rows + 2 * r3;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx23] = a[r3][c];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx23 + 1] = a[r3][c + 1];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx32] = a[r3][c + 2];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx32 + 1] = a[r3][c + 3];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx4] = a[r3][c + 4];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx4 + 1] = a[r3][c + 5];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx5] = a[r3][c + 6];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[idx5 + 1] = a[r3][c + 7];
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 6 * FloatFFT_2D.this.rows);
                                        for (r3 = 0; r3 < FloatFFT_2D.this.rows; ++r3) {
                                            idx23 = startt + 2 * r3;
                                            idx32 = startt + 2 * FloatFFT_2D.this.rows + 2 * r3;
                                            idx4 = idx32 + 2 * FloatFFT_2D.this.rows;
                                            idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                            a[r3][c] = FloatFFT_2D.this.t[idx23];
                                            a[r3][c + 1] = FloatFFT_2D.this.t[idx23 + 1];
                                            a[r3][c + 2] = FloatFFT_2D.this.t[idx32];
                                            a[r3][c + 3] = FloatFFT_2D.this.t[idx32 + 1];
                                            a[r3][c + 4] = FloatFFT_2D.this.t[idx4];
                                            a[r3][c + 5] = FloatFFT_2D.this.t[idx4 + 1];
                                            a[r3][c + 6] = FloatFFT_2D.this.t[idx5];
                                            a[r3][c + 7] = FloatFFT_2D.this.t[idx5 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * nthreads) break block22;
                                for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                    idx22 = startt + 2 * r2;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r2;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx22] = a[r2][4 * n0];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx22 + 1] = a[r2][4 * n0 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[r2][4 * n0 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[r2][4 * n0 + 3];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows);
                                for (r2 = 0; r2 < FloatFFT_2D.this.rows; ++r2) {
                                    idx22 = startt + 2 * r2;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r2;
                                    a[r2][4 * n0] = FloatFFT_2D.this.t[idx22];
                                    a[r2][4 * n0 + 1] = FloatFFT_2D.this.t[idx22 + 1];
                                    a[r2][4 * n0 + 2] = FloatFFT_2D.this.t[idx3];
                                    a[r2][4 * n0 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * nthreads) break block21;
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[r][2 * n0];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[r][2 * n0 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, startt);
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                a[r][2 * n0] = FloatFFT_2D.this.t[idx2];
                                a[r][2 * n0 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * nthreads) {
                            for (int c = 8 * n0; c < FloatFFT_2D.this.columns; c += 8 * nthreads) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int r;
                                for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[r][c];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[r][c + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[r][c + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[r][c + 3];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx4] = a[r][c + 4];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx4 + 1] = a[r][c + 5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx5] = a[r][c + 6];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[idx5 + 1] = a[r][c + 7];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 4 * FloatFFT_2D.this.rows, scale);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 6 * FloatFFT_2D.this.rows, scale);
                                for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                    idx4 = idx3 + 2 * FloatFFT_2D.this.rows;
                                    idx5 = idx4 + 2 * FloatFFT_2D.this.rows;
                                    a[r][c] = FloatFFT_2D.this.t[idx2];
                                    a[r][c + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                    a[r][c + 2] = FloatFFT_2D.this.t[idx3];
                                    a[r][c + 3] = FloatFFT_2D.this.t[idx3 + 1];
                                    a[r][c + 4] = FloatFFT_2D.this.t[idx4];
                                    a[r][c + 5] = FloatFFT_2D.this.t[idx4 + 1];
                                    a[r][c + 6] = FloatFFT_2D.this.t[idx5];
                                    a[r][c + 7] = FloatFFT_2D.this.t[idx5 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[r][4 * n0];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[r][4 * n0 + 1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx3] = a[r][4 * n0 + 2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx3 + 1] = a[r][4 * n0 + 3];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt + 2 * FloatFFT_2D.this.rows, scale);
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                idx3 = startt + 2 * FloatFFT_2D.this.rows + 2 * r;
                                a[r][4 * n0] = FloatFFT_2D.this.t[idx2];
                                a[r][4 * n0 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                                a[r][4 * n0 + 2] = FloatFFT_2D.this.t[idx3];
                                a[r][4 * n0 + 3] = FloatFFT_2D.this.t[idx3 + 1];
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * nthreads) {
                            int idx2;
                            int r;
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2] = a[r][2 * n0];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[idx2 + 1] = a[r][2 * n0 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, startt, scale);
                            for (r = 0; r < FloatFFT_2D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                a[r][2 * n0] = FloatFFT_2D.this.t[idx2];
                                a[r][2 * n0 + 1] = FloatFFT_2D.this.t[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void fillSymmetric(final float[] a) {
        int idx2;
        int idx1;
        int twon2 = 2 * this.columns;
        int n1d2 = this.rows / 2;
        for (int r = this.rows - 1; r >= 1; --r) {
            idx1 = r * this.columns;
            idx2 = 2 * idx1;
            for (int c = 0; c < this.columns; c += 2) {
                a[idx2 + c] = a[idx1 + c];
                a[idx1 + c] = 0.0f;
                a[idx2 + c + 1] = a[idx1 + c + 1];
                a[idx1 + c + 1] = 0.0f;
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads) {
            Future[] futures = new Future[nthreads];
            int l1k = n1d2 / nthreads;
            final int newn2 = 2 * this.columns;
            for (int i = 0; i < nthreads; ++i) {
                final int l1offa = i == 0 ? i * l1k + 1 : i * l1k;
                final int l1stopa = i * l1k + l1k;
                final int l2offa = i * l1k;
                final int l2stopa = i == nthreads - 1 ? i * l1k + l1k + 1 : i * l1k + l1k;
                futures[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx4;
                        int c;
                        int idx3;
                        int idx2;
                        int idx1;
                        int r;
                        for (r = l1offa; r < l1stopa; ++r) {
                            idx1 = r * newn2;
                            idx2 = (FloatFFT_2D.this.rows - r) * newn2;
                            idx3 = idx1 + FloatFFT_2D.this.columns;
                            a[idx3] = a[idx2 + 1];
                            a[idx3 + 1] = -a[idx2];
                        }
                        for (r = l1offa; r < l1stopa; ++r) {
                            idx1 = r * newn2;
                            idx3 = (FloatFFT_2D.this.rows - r + 1) * newn2;
                            for (c = FloatFFT_2D.this.columns + 2; c < newn2; c += 2) {
                                idx2 = idx3 - c;
                                idx4 = idx1 + c;
                                a[idx4] = a[idx2];
                                a[idx4 + 1] = -a[idx2 + 1];
                            }
                        }
                        for (r = l2offa; r < l2stopa; ++r) {
                            idx3 = (FloatFFT_2D.this.rows - r) % FloatFFT_2D.this.rows * newn2;
                            idx4 = r * newn2;
                            for (c = 0; c < newn2; c += 2) {
                                idx1 = idx3 + (newn2 - c) % newn2;
                                idx2 = idx4 + c;
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int idx3;
            int r;
            for (r = 1; r < n1d2; ++r) {
                idx2 = r * twon2;
                idx3 = (this.rows - r) * twon2;
                a[idx2 + this.columns] = a[idx3 + 1];
                a[idx2 + this.columns + 1] = -a[idx3];
            }
            for (r = 1; r < n1d2; ++r) {
                idx2 = r * twon2;
                idx3 = (this.rows - r + 1) * twon2;
                for (c = this.columns + 2; c < twon2; c += 2) {
                    a[idx2 + c] = a[idx3 - c];
                    a[idx2 + c + 1] = -a[idx3 - c + 1];
                }
            }
            for (r = 0; r <= this.rows / 2; ++r) {
                idx1 = r * twon2;
                int idx4 = (this.rows - r) % this.rows * twon2;
                for (c = 0; c < twon2; c += 2) {
                    idx2 = idx1 + c;
                    idx3 = idx4 + (twon2 - c) % twon2;
                    a[idx3] = a[idx2];
                    a[idx3 + 1] = -a[idx2 + 1];
                }
            }
        }
        a[this.columns] = -a[1];
        a[1] = 0.0f;
        idx1 = n1d2 * twon2;
        a[idx1 + this.columns] = -a[idx1 + 1];
        a[idx1 + 1] = 0.0f;
        a[idx1 + this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final float[][] a) {
        final int newn2 = 2 * this.columns;
        int n1d2 = this.rows / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads) {
            Future[] futures = new Future[nthreads];
            int l1k = n1d2 / nthreads;
            for (int i = 0; i < nthreads; ++i) {
                final int l1offa = i == 0 ? i * l1k + 1 : i * l1k;
                final int l1stopa = i * l1k + l1k;
                final int l2offa = i * l1k;
                final int l2stopa = i == nthreads - 1 ? i * l1k + l1k + 1 : i * l1k + l1k;
                futures[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx2;
                        int c;
                        int idx1;
                        int r;
                        for (r = l1offa; r < l1stopa; ++r) {
                            idx1 = FloatFFT_2D.this.rows - r;
                            a[r][((FloatFFT_2D)FloatFFT_2D.this).columns] = a[idx1][1];
                            a[r][((FloatFFT_2D)FloatFFT_2D.this).columns + 1] = -a[idx1][0];
                        }
                        for (r = l1offa; r < l1stopa; ++r) {
                            idx1 = FloatFFT_2D.this.rows - r;
                            for (c = FloatFFT_2D.this.columns + 2; c < newn2; c += 2) {
                                idx2 = newn2 - c;
                                a[r][c] = a[idx1][idx2];
                                a[r][c + 1] = -a[idx1][idx2 + 1];
                            }
                        }
                        for (r = l2offa; r < l2stopa; ++r) {
                            idx1 = (FloatFFT_2D.this.rows - r) % FloatFFT_2D.this.rows;
                            for (c = 0; c < newn2; c += 2) {
                                idx2 = (newn2 - c) % newn2;
                                a[idx1][idx2] = a[r][c];
                                a[idx1][idx2 + 1] = -a[r][c + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx2;
            int c;
            int idx1;
            int r;
            for (r = 1; r < n1d2; ++r) {
                idx1 = this.rows - r;
                a[r][this.columns] = a[idx1][1];
                a[r][this.columns + 1] = -a[idx1][0];
            }
            for (r = 1; r < n1d2; ++r) {
                idx1 = this.rows - r;
                for (c = this.columns + 2; c < newn2; c += 2) {
                    idx2 = newn2 - c;
                    a[r][c] = a[idx1][idx2];
                    a[r][c + 1] = -a[idx1][idx2 + 1];
                }
            }
            for (r = 0; r <= this.rows / 2; ++r) {
                idx1 = (this.rows - r) % this.rows;
                for (c = 0; c < newn2; c += 2) {
                    idx2 = (newn2 - c) % newn2;
                    a[idx1][idx2] = a[r][c];
                    a[idx1][idx2 + 1] = -a[r][c + 1];
                }
            }
        }
        a[0][this.columns] = -a[0][1];
        a[0][1] = 0.0f;
        a[n1d2][this.columns] = -a[n1d2][1];
        a[n1d2][1] = 0.0f;
        a[n1d2][this.columns + 1] = 0.0f;
    }
}

