/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.DoubleDHT_1D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleDHT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static double eps = Math.pow(2.0, -52.0);

    private AccuracyCheckDoubleDHT() {
    }

    public static void checkAccuracyDHT_1D() {
        System.out.println("Checking accuracy of 1D DHT...");
        for (int i = 0; i < sizes1D.length; ++i) {
            DoubleDHT_1D fht = new DoubleDHT_1D(sizes1D[i]);
            double err = 0.0;
            double[] a = new double[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], a);
            double[] b = new double[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], b);
            fht.forward(a);
            fht.inverse(a, true);
            err = AccuracyCheckDoubleDHT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fht = null;
            System.gc();
        }
    }

    public static void checkAccuracyDHT_2D() {
        Object b;
        Object a;
        double err;
        DoubleDHT_2D fht2;
        int i;
        System.out.println("Checking accuracy of 2D DHT (double[] input)...");
        for (i = 0; i < sizes2D.length; ++i) {
            fht2 = new DoubleDHT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new double[sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], a);
            b = new double[sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], b);
            fht2.forward((double[])a);
            fht2.inverse((double[])a, true);
            err = AccuracyCheckDoubleDHT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fht2 = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DHT (double[][] input)...");
        for (i = 0; i < sizes2D.length; ++i) {
            fht2 = new DoubleDHT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new double[sizes2D[i]][sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (double[][])a);
            b = new double[sizes2D[i]][sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (double[][])b);
            fht2.forward((double[][])a);
            fht2.inverse((double[][])a, true);
            err = AccuracyCheckDoubleDHT.computeRMSE((double[][])a, (double[][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fht2 = null;
            System.gc();
        }
    }

    public static void checkAccuracyDHT_3D() {
        Object b;
        Object a;
        double err;
        DoubleDHT_3D dht3;
        int i;
        System.out.println("Checking accuracy of 3D DHT (double[] input)...");
        for (i = 0; i < sizes3D.length; ++i) {
            dht3 = new DoubleDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new double[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], a);
            b = new double[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], b);
            dht3.forward((double[])a);
            dht3.inverse((double[])a, true);
            err = AccuracyCheckDoubleDHT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            dht3 = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DHT (double[][][] input)...");
        for (i = 0; i < sizes3D.length; ++i) {
            dht3 = new DoubleDHT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new double[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (double[][][])a);
            b = new double[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (double[][][])b);
            dht3.forward((double[][][])a);
            dht3.inverse((double[][][])a, true);
            err = AccuracyCheckDoubleDHT.computeRMSE((double[][][])a, (double[][][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            dht3 = null;
            System.gc();
        }
    }

    private static double computeRMSE(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double tmp = a[i] - b[i];
            rms += tmp * tmp;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    private static double computeRMSE(double[][] a, double[][] b) {
        if (a.length != b.length || a[0].length != b[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int r = 0; r < a.length; ++r) {
            for (int c = 0; c < a[0].length; ++c) {
                double tmp = a[r][c] - b[r][c];
                rms += tmp * tmp;
            }
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length));
    }

    private static double computeRMSE(double[][][] a, double[][][] b) {
        if (a.length != b.length || a[0].length != b[0].length || a[0][0].length != b[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int s = 0; s < a.length; ++s) {
            for (int r = 0; r < a[0].length; ++r) {
                for (int c = 0; c < a[0][0].length; ++c) {
                    double tmp = a[s][r][c] - b[s][r][c];
                    rms += tmp * tmp;
                }
            }
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length * a[0][0].length));
    }

    public static void main(String[] args) {
        AccuracyCheckDoubleDHT.checkAccuracyDHT_1D();
        AccuracyCheckDoubleDHT.checkAccuracyDHT_2D();
        AccuracyCheckDoubleDHT.checkAccuracyDHT_3D();
        System.exit(0);
    }
}

