/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.rdf.utils;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ParameterizedSparqlString;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;

public class PQUtils {
    public static void setPSSLiteral(ParameterizedSparqlString pss, String[] strings, double[] geo) {
        for (int i = 0; i < strings.length; ++i) {
            if (geo == null) {
                PQUtils.setNull(pss, strings[i]);
                continue;
            }
            pss.setLiteral(strings[i], geo[i]);
        }
    }

    public static void setNull(ParameterizedSparqlString pss, String name) {
        pss.setLiteral(name, Node.NULL.toString());
    }

    public static void setPSSLiteral(ParameterizedSparqlString pss, String name, double d) {
        pss.setLiteral(name, d);
    }

    public static void setPSSLiteral(ParameterizedSparqlString pss, String name, int d) {
        pss.setLiteral(name, d);
    }

    public static void setPSSLiteral(ParameterizedSparqlString pss, String name, String lit) {
        if (lit != null) {
            pss.setLiteral(name, lit);
        } else {
            PQUtils.setNull(pss, name);
        }
    }

    public static void setPSSIri(ParameterizedSparqlString pss, String name, String iri) {
        if (iri != null) {
            pss.setIri(name, iri);
        } else {
            PQUtils.setNull(pss, name);
        }
    }

    public static void setPSSResource(ParameterizedSparqlString pss, String name, Resource iri) {
        if (iri != null) {
            pss.setParam(name, (RDFNode)iri);
        } else {
            PQUtils.setNull(pss, name);
        }
    }

    public static ParameterizedSparqlString constructPQ(String query, Model m) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString(query, (PrefixMapping)m);
        return pss;
    }
}

