/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.rdf.serialize;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javassist.Modifier;
import org.openimaj.rdf.serialize.Predicate;
import org.openimaj.rdf.serialize.RDFCollection;
import org.openimaj.rdf.serialize.RDFType;
import org.openimaj.rdf.serialize.RelationList;
import org.openimaj.rdf.serialize.TripleList;
import org.openimaj.util.pair.IndependentPair;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.springframework.core.ResolvableType;

public class RDFSerializer {
    public static final String RDF_OPENIMAJ_TMP_GRAPH = "http://rdf.openimaj.org/tmp/";
    public static final String RDF_OPENIMAJ_P_CLASSNAME = "http://rdf.openimaj.org/hasClassName/";
    public static final String RDF_OPENIMAJ_P_COLLECTIONITEM = "http://rdf.openimaj.org/hasCollectionItem/";
    protected boolean autoPredicate = false;
    protected boolean outputClassNames = true;
    private HashSet<URI> knownGraphs = null;

    public RDFSerializer() {
        this(false);
    }

    public RDFSerializer(boolean autoPredicate) {
        this.autoPredicate = autoPredicate;
    }

    public URI serialize(Object objectToSerialize, String uri) {
        this.knownGraphs = new HashSet();
        URI i = this.serializeAux(objectToSerialize, uri);
        return i;
    }

    public URI serializeAux(Object objectToSerialize, String uri) {
        return this.serializeAux(objectToSerialize, uri, true);
    }

    public URI serializeAux(Object objectToSerialize, String uri, boolean outputCollectionObjects) {
        RDFType typeAnnotation;
        URIImpl subject = new URIImpl(uri);
        if (this.knownGraphs.contains(subject = this.getObjectURI(objectToSerialize, subject))) {
            return subject;
        }
        this.knownGraphs.add((URI)subject);
        if (this.outputClassNames) {
            this.addTriple((Statement)new StatementImpl((Resource)subject, (URI)new URIImpl(RDF_OPENIMAJ_P_CLASSNAME), this.checkPrimitive(objectToSerialize.getClass().getName())));
        }
        if ((typeAnnotation = objectToSerialize.getClass().getAnnotation(RDFType.class)) != null) {
            this.addTriple((Statement)new StatementImpl((Resource)subject, RDF.TYPE, (Value)new URIImpl(typeAnnotation.value())));
        }
        if (objectToSerialize instanceof Collection && outputCollectionObjects) {
            this.processCollection(subject, new URIImpl(RDF_OPENIMAJ_P_COLLECTIONITEM), subject, "", objectToSerialize, false);
        }
        List<Field> fields = this.getAllFields(objectToSerialize);
        for (Field field : fields) {
            if (Modifier.isStatic((int)field.getModifiers())) continue;
            try {
                URIImpl predicate;
                field.setAccessible(true);
                Object oo = field.get(objectToSerialize);
                if (this.outputSpecial(oo, field, subject) || (predicate = this.getPredicateName(field, uri)) == null) continue;
                this.processObject(subject, predicate, field.getName(), oo, field.getAnnotation(RDFCollection.class) != null);
            }
            catch (Exception e) {
                System.out.println("Error reflecting " + field);
                e.printStackTrace();
            }
        }
        return subject;
    }

    private void processObject(URIImpl subject, URIImpl predicate, String fieldName, Object oo, boolean asCollection) {
        String uri = subject.stringValue();
        if (oo != null && predicate != null) {
            boolean isCollective = false;
            Value object = this.checkPrimitive(oo);
            if (object == null) {
                URIImpl objectURI = this.getObjectURI(oo, new URIImpl(subject.stringValue() + "_" + fieldName));
                if (oo.getClass().isArray()) {
                    isCollective = true;
                    object = this.processArray(subject, predicate, objectURI, fieldName, oo, asCollection);
                } else if (oo instanceof Collection) {
                    isCollective = true;
                    object = this.processCollection(subject, predicate, objectURI, fieldName, oo, asCollection);
                } else {
                    object = new URIImpl(uri + "_" + fieldName);
                    object = this.serializeAux(oo, object.stringValue());
                }
            }
            if (!isCollective || isCollective && asCollection) {
                StatementImpl t = new StatementImpl((Resource)subject, (URI)predicate, object);
                this.addTriple((Statement)t);
            }
        }
    }

    private Value processArray(URIImpl subject, URIImpl predicate, URIImpl collectionURI, String fieldName, Object arrayObject, boolean asCollection) {
        int count = 0;
        while (count < Array.getLength(arrayObject)) {
            Object o = Array.get(arrayObject, count);
            count = this.processListItemObject(subject, predicate, collectionURI, count, o, asCollection);
        }
        return collectionURI;
    }

    private Value processCollection(URIImpl subject, URIImpl predicate, URIImpl collectionURI, String fieldName, Object collectionObject, boolean asCollection) {
        int count = 1;
        for (Object o : (Collection)collectionObject) {
            count = this.processListItemObject(subject, predicate, collectionURI, count, o, asCollection);
        }
        URI object = this.serializeAux(collectionObject, collectionURI.stringValue(), false);
        return object;
    }

    private int processListItemObject(URIImpl subject, URIImpl predicate, URIImpl collectionURI, int listCounter, Object listItemObject, boolean asSequence) {
        if (asSequence) {
            predicate = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + listCounter);
            subject = collectionURI;
        }
        Value oo = null;
        oo = this.checkPrimitive(listItemObject);
        if (oo == null) {
            oo = this.getObjectURI(listItemObject, new URIImpl(collectionURI.stringValue() + "_listItem" + listCounter));
            this.addTriple((Statement)new StatementImpl((Resource)subject, (URI)predicate, oo));
            this.serializeAux(listItemObject, oo.stringValue());
        } else {
            this.addTriple((Statement)new StatementImpl((Resource)subject, (URI)predicate, oo));
        }
        return listCounter + 1;
    }

    private URIImpl getPredicateName(Field field, String uri) {
        Predicate predicateAnnotation = field.getAnnotation(Predicate.class);
        URIImpl predicate = null;
        if (predicateAnnotation != null) {
            predicate = new URIImpl(predicateAnnotation.value());
        } else if (this.autoPredicate) {
            predicate = new URIImpl(uri + "_has" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1));
        }
        return predicate;
    }

    private Value checkPrimitive(Object o) {
        if (o instanceof String) {
            return new LiteralImpl(o.toString());
        }
        if (o instanceof Integer) {
            return new ValueFactoryImpl().createLiteral(((Integer)o).intValue());
        }
        if (o instanceof Float) {
            return new ValueFactoryImpl().createLiteral(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new ValueFactoryImpl().createLiteral(((Double)o).doubleValue());
        }
        if (o instanceof URI || o instanceof URL || o instanceof java.net.URI) {
            return new URIImpl(o.toString());
        }
        return null;
    }

    private List<Field> getAllFields(Object o) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> objectToGetFieldsFrom = o.getClass();
        do {
            fields.addAll(Arrays.asList(objectToGetFieldsFrom.getDeclaredFields()));
        } while (!(objectToGetFieldsFrom = objectToGetFieldsFrom.getSuperclass()).getSimpleName().equals("Object"));
        return fields;
    }

    public void setOutputClassNames(boolean tf) {
        this.outputClassNames = tf;
    }

    public void setAutoPredicate(boolean tf) {
        this.autoPredicate = tf;
    }

    public <T> T unserialize(T objectToUnserialize, String objectRootURI, String rdf, RDFFormat rdfFormat) {
        try {
            SailRepository repo = new SailRepository((Sail)new MemoryStore());
            repo.initialize();
            RepositoryConnection connection = repo.getConnection();
            StringReader sr = new StringReader(rdf);
            String graphURI = RDF_OPENIMAJ_TMP_GRAPH;
            connection.add((Reader)sr, RDF_OPENIMAJ_TMP_GRAPH, rdfFormat, new Resource[0]);
            return this.unserialize(objectToUnserialize, objectRootURI, (Repository)repo);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
        catch (RDFParseException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T unserialize(T objectToUnserialize, String objectRootURI, Repository repo) {
        if (objectToUnserialize == null) {
            System.err.println("Unserialize error: given object is null");
            return null;
        }
        if (objectToUnserialize instanceof Collection) {
            this.extractCollectionDirect((Collection)objectToUnserialize, objectRootURI, repo);
        }
        try {
            Field[] fields;
            RepositoryConnection connection = repo.getConnection();
            for (Field field : fields = objectToUnserialize.getClass().getFields()) {
                try {
                    URIImpl predicateName = this.getPredicateName(field, objectRootURI);
                    if (predicateName == null) continue;
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        this.unserializeCollection(field, objectToUnserialize, objectRootURI, repo, predicateName);
                        continue;
                    }
                    if (field.getType().isArray()) {
                        this.unserializeArray(objectToUnserialize, objectRootURI, repo, field, predicateName);
                        continue;
                    }
                    try {
                        String queryString = "SELECT ?o WHERE {<" + objectRootURI + "> <" + predicateName + "> ?o.}";
                        TupleQuery tupleQuery = connection.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
                        TupleQueryResult result = tupleQuery.evaluate();
                        if (!result.hasNext()) continue;
                        try {
                            BindingSet bindingSet = (BindingSet)result.next();
                            Value objectValue = bindingSet.getValue("o");
                            field.setAccessible(true);
                            field.set(objectToUnserialize, this.getFieldValue(field.getGenericType(), objectValue, repo, field.getName(), objectRootURI));
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (MalformedQueryException e) {
                        e.printStackTrace();
                    }
                    catch (QueryEvaluationException e) {
                        e.printStackTrace();
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            connection.close();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return objectToUnserialize;
    }

    private <T extends Collection<?>> void extractCollectionDirect(T objectToUnserialize, String objectRootURI, Repository repo) {
        Class collectionType = ResolvableType.forClass(objectToUnserialize.getClass()).asCollection().resolveGeneric(new int[0]);
        T[] seq = this.extractCollectionObjects(objectRootURI, repo, collectionType, "", objectRootURI, RDF_OPENIMAJ_P_COLLECTIONITEM);
        objectToUnserialize.clear();
        for (int i = 0; i < seq.length; ++i) {
            objectToUnserialize.add(seq[i]);
        }
    }

    private <T> void unserializeArray(T objectToUnserialize, String objectRootURI, Repository repo, Field field, URIImpl predicateName) throws IllegalAccessException {
        Class<?> componentType = field.getType().getComponentType();
        ?[] seq = this.extractCollectionObjects(objectRootURI, repo, componentType, field.getName(), objectRootURI, predicateName.stringValue());
        field.setAccessible(true);
        field.set(objectToUnserialize, seq);
    }

    private void unserializeCollection(Field field, Object objectToUnserialize, String objectRootURI, Repository repo, URIImpl predicateURI) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            try {
                Object newInstance;
                Class cls = field.getType();
                try {
                    newInstance = cls.newInstance();
                }
                catch (InstantiationException e) {
                    cls = (Class)this.getObjectClass(objectRootURI + "_" + field.getName(), repo);
                    if (cls == null) {
                        return;
                    }
                    newInstance = cls.newInstance();
                }
                Collection collection = (Collection)newInstance;
                collection.clear();
                Class collectionType = null;
                collectionType = ResolvableType.forField((Field)field).asCollection().resolveGeneric(new int[0]);
                T[] seq = this.extractCollectionObjects(objectRootURI, repo, collectionType, field.getName(), objectRootURI, predicateURI.stringValue());
                if (seq != null) {
                    for (int i = 0; i < seq.length; ++i) {
                        collection.add(seq[i]);
                    }
                    field.setAccessible(true);
                    field.set(objectToUnserialize, collection);
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("WARNING: Unserialize collection called for something that's not a collection.");
        }
    }

    private Object getFieldValue(Type type, Value value, Repository repo, String fieldName, String subjectURI) {
        try {
            if (type.equals(String.class)) {
                return value.stringValue();
            }
            if (type.equals(java.net.URI.class)) {
                try {
                    return new java.net.URI(value.toString());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            } else if (type.equals(URL.class)) {
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                    return Integer.parseInt(value.stringValue());
                }
                if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                    return Double.parseDouble(value.stringValue());
                }
                if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                    return Float.valueOf(Float.parseFloat(value.stringValue()));
                }
                try {
                    if (value instanceof URI) {
                        String objectURI = value.stringValue();
                        Type type2 = this.getObjectClass(objectURI, repo);
                        if (type2 == null) {
                            objectURI = subjectURI + "_" + fieldName;
                            type2 = this.getObjectClass(objectURI, repo);
                        }
                        Object newInstance = ((Class)type2).newInstance();
                        return this.unserialize(newInstance, objectURI, repo);
                    }
                    System.out.println("WARNING: I don't know what to do with " + value);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isRDFSequence(Repository repo, String collectionURI) {
        try {
            RepositoryConnection c = repo.getConnection();
            String queryString = "ASK {<" + collectionURI + "> <" + RDF.TYPE + "> <" + RDF.SEQ + ">}";
            BooleanQuery query = c.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
            return query.evaluate();
        }
        catch (RepositoryException e1) {
            e1.printStackTrace();
        }
        catch (MalformedQueryException e1) {
            e1.printStackTrace();
        }
        catch (QueryEvaluationException e1) {
            e1.printStackTrace();
        }
        return false;
    }

    private <T> T[] extractCollectionObjects(String collectionURI, Repository repo, Class<T> componentType, String fieldName, String subject, String predicate) {
        Object[] sequence = null;
        if (this.isRDFSequence(repo, collectionURI)) {
            HashMap<Integer, BindingSet> tmpMap = new HashMap<Integer, BindingSet>();
            try {
                int max = this.extractRDFSequenceObjects(collectionURI, repo, tmpMap);
                if (max < 0) {
                    return null;
                }
                sequence = (Object[])Array.newInstance(componentType, max);
                for (int i : tmpMap.keySet()) {
                    sequence[i - 1] = this.getFieldValue(componentType, tmpMap.get(i).getValue("o"), repo, fieldName, collectionURI);
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            catch (MalformedQueryException e) {
                e.printStackTrace();
            }
            catch (QueryEvaluationException e) {
                e.printStackTrace();
            }
        } else {
            sequence = this.getUnorderedObjects(collectionURI, repo, componentType, fieldName, subject, predicate);
        }
        return sequence;
    }

    private int extractRDFSequenceObjects(String collectionURI, Repository repo, HashMap<Integer, BindingSet> objectMap) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        int max = -1;
        RepositoryConnection c = repo.getConnection();
        String queryString = "SELECT ?p ?o WHERE {<" + collectionURI + "> ?p ?o} ORDER BY DESC(?p)";
        TupleQuery tupleQuery = c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
        TupleQueryResult result = tupleQuery.evaluate();
        while (result.hasNext()) {
            try {
                BindingSet bs = (BindingSet)result.next();
                int index = Integer.parseInt(bs.getValue("p").stringValue().substring("http://www.w3.org/1999/02/22-rdf-syntax-ns#_".length()));
                if (index < 0) continue;
                objectMap.put(index, bs);
                max = Math.max(index, max);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return max;
    }

    private <T> T[] getUnorderedObjects(String sequenceURI, Repository repo, Class<T> fieldType, String fieldName, String subjectURI, String predicate) {
        try {
            RepositoryConnection c = repo.getConnection();
            String queryString = "SELECT ?o WHERE {<" + subjectURI + "> <" + predicate + "> ?o}";
            TupleQuery tupleQuery = c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            TupleQueryResult result = tupleQuery.evaluate();
            ArrayList<Object> objs = new ArrayList<Object>();
            int n = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Value oo = bs.getBinding("o").getValue();
                objs.add(this.getFieldValue(fieldType, oo, repo, fieldName, sequenceURI));
                ++n;
            }
            Object[] arr = (Object[])Array.newInstance(fieldType, n);
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = objs.get(i);
            }
            return arr;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Type getObjectClass(String objectURI, Repository repo) {
        String queryString = null;
        try {
            RepositoryConnection c = repo.getConnection();
            queryString = "SELECT ?o WHERE {<" + objectURI + "> <" + RDF_OPENIMAJ_P_CLASSNAME + "> ?o.}";
            TupleQuery tupleQuery = c.prepareTupleQuery(QueryLanguage.SPARQL, queryString);
            TupleQueryResult result = tupleQuery.evaluate();
            Class<?> clazz = null;
            boolean found = false;
            while (!found && result.hasNext()) {
                Value value = ((BindingSet)result.next()).getValue("o");
                try {
                    clazz = Class.forName(value.stringValue());
                    found = true;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            c.close();
            if (clazz != null) {
                return clazz;
            }
        }
        catch (RepositoryException e) {
            System.out.println("Processing: " + queryString);
            e.printStackTrace();
        }
        catch (MalformedQueryException e) {
            System.out.println("Processing: " + queryString);
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            System.out.println("Processing: " + queryString);
            e.printStackTrace();
        }
        return null;
    }

    public URIImpl getObjectURI(Object obj, URIImpl defaultURI) {
        try {
            Method method = obj.getClass().getMethod("getURI", new Class[0]);
            URIImpl subject = new URIImpl(method.invoke(obj, (Object[])null).toString());
            return subject;
        }
        catch (NoSuchMethodException method) {
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return defaultURI;
    }

    private boolean outputSpecial(Object fieldValue, Field field, URIImpl subjectURI) {
        if (field.getAnnotation(TripleList.class) != null) {
            if (fieldValue instanceof Collection) {
                for (Object o : (Collection)fieldValue) {
                    if (!(o instanceof Statement)) continue;
                    this.addTriple((Statement)o);
                }
            }
            return true;
        }
        if (field.getAnnotation(RelationList.class) != null) {
            if (fieldValue instanceof Collection) {
                int count = 0;
                for (Object o : (Collection)fieldValue) {
                    if (o instanceof IndependentPair) {
                        IndependentPair ip = (IndependentPair)o;
                        Value ooo = this.checkPrimitive(ip.getSecondObject());
                        if (ooo != null) {
                            this.addTriple((Statement)new StatementImpl((Resource)subjectURI, (URI)new URIImpl(ip.getFirstObject().toString()), ooo));
                            continue;
                        }
                        URI subjU = this.serializeAux(ip.getSecondObject(), subjectURI + "_" + field.getName() + "_" + count++);
                        this.addTriple((Statement)new StatementImpl((Resource)subjectURI, (URI)new URIImpl(ip.getFirstObject().toString()), (Value)subjU));
                        continue;
                    }
                    this.serializeAux(o, subjectURI + "_" + field.getName() + "_" + count++);
                }
            }
            return true;
        }
        return false;
    }

    public void addTriple(Statement t) {
    }
}

