/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Timer;

class FSNamesystemLock {
    @VisibleForTesting
    protected ReentrantReadWriteLock coarseLock;
    private final Timer timer;
    private final long lockSuppressWarningInterval;
    private final long writeLockReportingThreshold;
    private long writeLockHeldTimeStamp;
    private int numWriteLockWarningsSuppressed = 0;
    private long timeStampOfLastWriteLockReport = 0L;
    private long longestWriteLockHeldInterval = 0L;
    private final long readLockReportingThreshold;
    private final ThreadLocal<Long> readLockHeldTimeStamp = new ThreadLocal<Long>(){

        @Override
        public Long initialValue() {
            return Long.MAX_VALUE;
        }
    };
    private final AtomicInteger numReadLockWarningsSuppressed = new AtomicInteger(0);
    private final AtomicLong timeStampOfLastReadLockReport = new AtomicLong(0L);
    private final AtomicLong longestReadLockHeldInterval = new AtomicLong(0L);

    FSNamesystemLock(Configuration conf) {
        this(conf, new Timer());
    }

    @VisibleForTesting
    FSNamesystemLock(Configuration conf, Timer timer) {
        boolean fair = conf.getBoolean("dfs.namenode.fslock.fair", true);
        FSNamesystem.LOG.info((Object)("fsLock is fair: " + fair));
        this.coarseLock = new ReentrantReadWriteLock(fair);
        this.timer = timer;
        this.writeLockReportingThreshold = conf.getLong("dfs.namenode.write-lock-reporting-threshold-ms", 5000L);
        this.readLockReportingThreshold = conf.getLong("dfs.namenode.read-lock-reporting-threshold-ms", 5000L);
        this.lockSuppressWarningInterval = conf.getTimeDuration("dfs.lock.suppress.warning.interval", 10000L, TimeUnit.MILLISECONDS);
    }

    public void readLock() {
        this.coarseLock.readLock().lock();
        if (this.coarseLock.getReadHoldCount() == 1) {
            this.readLockHeldTimeStamp.set(this.timer.monotonicNow());
        }
    }

    public void readUnlock() {
        boolean needReport = this.coarseLock.getReadHoldCount() == 1;
        long readLockInterval = this.timer.monotonicNow() - this.readLockHeldTimeStamp.get();
        this.coarseLock.readLock().unlock();
        if (needReport) {
            this.readLockHeldTimeStamp.remove();
        }
        if (needReport && readLockInterval >= this.readLockReportingThreshold) {
            long now;
            long localTimeStampOfLastReadLockReport;
            long localLongestReadLock;
            while ((localLongestReadLock = this.longestReadLockHeldInterval.get()) - readLockInterval < 0L && !this.longestReadLockHeldInterval.compareAndSet(localLongestReadLock, readLockInterval)) {
            }
            do {
                if ((now = this.timer.monotonicNow()) - (localTimeStampOfLastReadLockReport = this.timeStampOfLastReadLockReport.get()) >= this.lockSuppressWarningInterval) continue;
                this.numReadLockWarningsSuppressed.incrementAndGet();
                return;
            } while (!this.timeStampOfLastReadLockReport.compareAndSet(localTimeStampOfLastReadLockReport, now));
            int numSuppressedWarnings = this.numReadLockWarningsSuppressed.getAndSet(0);
            long longestLockHeldInterval = this.longestReadLockHeldInterval.getAndSet(0L);
            FSNamesystem.LOG.info((Object)("FSNamesystem read lock held for " + readLockInterval + " ms via\n" + StringUtils.getStackTrace((Thread)Thread.currentThread()) + "\tNumber of suppressed read-lock reports: " + numSuppressedWarnings + "\n\tLongest read-lock held interval: " + longestLockHeldInterval));
        }
    }

    public void writeLock() {
        this.coarseLock.writeLock().lock();
        if (this.coarseLock.getWriteHoldCount() == 1) {
            this.writeLockHeldTimeStamp = this.timer.monotonicNow();
        }
    }

    public void writeLockInterruptibly() throws InterruptedException {
        this.coarseLock.writeLock().lockInterruptibly();
        if (this.coarseLock.getWriteHoldCount() == 1) {
            this.writeLockHeldTimeStamp = this.timer.monotonicNow();
        }
    }

    public void writeUnlock() {
        boolean needReport = this.coarseLock.getWriteHoldCount() == 1 && this.coarseLock.isWriteLockedByCurrentThread();
        long currentTime = this.timer.monotonicNow();
        long writeLockInterval = currentTime - this.writeLockHeldTimeStamp;
        boolean logReport = false;
        int numSuppressedWarnings = 0;
        long longestLockHeldInterval = 0L;
        if (needReport && writeLockInterval >= this.writeLockReportingThreshold) {
            if (writeLockInterval > this.longestWriteLockHeldInterval) {
                this.longestWriteLockHeldInterval = writeLockInterval;
            }
            if (currentTime - this.timeStampOfLastWriteLockReport > this.lockSuppressWarningInterval) {
                logReport = true;
                numSuppressedWarnings = this.numWriteLockWarningsSuppressed;
                this.numWriteLockWarningsSuppressed = 0;
                longestLockHeldInterval = this.longestWriteLockHeldInterval;
                this.longestWriteLockHeldInterval = 0L;
                this.timeStampOfLastWriteLockReport = currentTime;
            } else {
                ++this.numWriteLockWarningsSuppressed;
            }
        }
        this.coarseLock.writeLock().unlock();
        if (logReport) {
            FSNamesystem.LOG.info((Object)("FSNamesystem write lock held for " + writeLockInterval + " ms via\n" + StringUtils.getStackTrace((Thread)Thread.currentThread()) + "\tNumber of suppressed write-lock reports: " + numSuppressedWarnings + "\n\tLongest write-lock held interval: " + longestLockHeldInterval));
        }
    }

    public int getReadHoldCount() {
        return this.coarseLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.coarseLock.getWriteHoldCount();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.coarseLock.isWriteLockedByCurrentThread();
    }

    public Condition newWriteLockCondition() {
        return this.coarseLock.writeLock().newCondition();
    }

    public int getQueueLength() {
        return this.coarseLock.getQueueLength();
    }
}

