/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.io.netty.buffer;

import com.cloudera.io.netty.buffer.AbstractByteBufAllocator;
import com.cloudera.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.cloudera.io.netty.buffer.ByteBuf;
import com.cloudera.io.netty.buffer.ByteBufAllocator;
import com.cloudera.io.netty.buffer.UnpooledDirectByteBuf;
import com.cloudera.io.netty.buffer.UnpooledHeapByteBuf;
import com.cloudera.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.cloudera.io.netty.util.internal.PlatformDependent;

public final class UnpooledByteBufAllocator
extends AbstractByteBufAllocator {
    public static final UnpooledByteBufAllocator DEFAULT = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    public UnpooledByteBufAllocator(boolean preferDirect) {
        super(preferDirect);
    }

    @Override
    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return new UnpooledHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
    }

    @Override
    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        AbstractReferenceCountedByteBuf buf = PlatformDependent.hasUnsafe() ? new UnpooledUnsafeDirectByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity) : new UnpooledDirectByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
        return UnpooledByteBufAllocator.toLeakAwareBuffer(buf);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return false;
    }
}

