/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.text.extraction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.image.Image;
import org.openimaj.image.processor.ImageProcessor;
import org.openimaj.image.text.ocr.OCRProcessor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.pair.IndependentPair;

public abstract class TextExtractor<T extends Image<?, T>>
implements ImageProcessor<T> {
    private OCRProcessor<T> ocr = null;

    public abstract Map<Rectangle, T> getTextRegions();

    public Map<Rectangle, IndependentPair<T, String>> getText() {
        HashMap<Rectangle, IndependentPair<T, String>> textMap = new HashMap<Rectangle, IndependentPair<T, String>>();
        Map<Rectangle, T> textRegions = this.getTextRegions();
        if (this.ocr != null) {
            for (Rectangle r : textRegions.keySet()) {
                ((Image)textRegions.get(r)).analyseWith(this.ocr);
                Map<Rectangle, String> m = this.ocr.getText();
                for (Rectangle subR : m.keySet()) {
                    String s = m.get(subR);
                    subR.translate(r.x, r.y);
                    textMap.put(subR, new IndependentPair(textRegions.get(r), (Object)s));
                }
            }
        } else {
            for (Rectangle r : textRegions.keySet()) {
                textMap.put(r, new IndependentPair(textRegions.get(r), null));
            }
        }
        return textMap;
    }

    public List<String> getTextStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.ocr != null) {
            Map<Rectangle, T> textRegions = this.getTextRegions();
            for (Rectangle r : textRegions.keySet()) {
                ((Image)textRegions.get(r)).analyseWith(this.ocr);
                Map<Rectangle, String> m = this.ocr.getText();
                strings.addAll(m.values());
            }
        }
        return strings;
    }

    public void setOCRProcessor(OCRProcessor<T> ocr) {
        this.ocr = ocr;
    }

    public OCRProcessor<T> getOCRProcessor() {
        return this.ocr;
    }
}

