/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.segmentation;

import org.openimaj.feature.FloatFVComparator;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.segmentation.KMColourSegmenter;

public class KMSpatialColourSegmenter
extends KMColourSegmenter {
    public KMSpatialColourSegmenter(ColourSpace colourSpace, int K) {
        super(colourSpace, K);
    }

    public KMSpatialColourSegmenter(ColourSpace colourSpace, int K, FloatFVComparator distance) {
        super(colourSpace, K, distance);
    }

    public KMSpatialColourSegmenter(ColourSpace colourSpace, float[] scaling, int K, FloatFVComparator distance) {
        super(colourSpace, scaling, K, distance);
    }

    public KMSpatialColourSegmenter(ColourSpace colourSpace, float[] scaling, int K, FloatFVComparator distance, int maxIters) {
        super(colourSpace, scaling, K, distance, maxIters);
    }

    @Override
    protected float[][] imageToVector(MBFImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        int bands = image.numBands();
        float[][] f = new float[height * width][bands + 2];
        for (int b = 0; b < bands; ++b) {
            float[][] band = ((FImage)image.getBand((int)b)).pixels;
            float w = this.scaling == null ? 1.0f : this.scaling[b];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    f[x + y * width][b] = band[y][x] * w;
                }
            }
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                f[x + y * width][bands] = (float)x / (float)width * (this.scaling == null ? 1.0f : this.scaling[bands]);
                f[x + y * width][bands + 1] = (float)y / (float)height * (this.scaling == null ? 1.0f : this.scaling[bands + 1]);
            }
        }
        return f;
    }
}

