/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.segmentation;

import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.connectedcomponent.ConnectedComponentLabeler;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.Processor;
import org.openimaj.image.segmentation.ThresholdSegmenter;

public class ConnectedThresholdSegmenter
extends ThresholdSegmenter {
    private ConnectedComponent.ConnectMode mode;
    private ConnectedComponentLabeler.Algorithm algorithm;

    public ConnectedThresholdSegmenter(Processor<FImage> thresholder, ConnectedComponent.ConnectMode mode) {
        this(thresholder, ConnectedComponentLabeler.Algorithm.TWO_PASS, mode);
    }

    public ConnectedThresholdSegmenter(Processor<FImage> thresholder, ConnectedComponentLabeler.Algorithm algorithm, ConnectedComponent.ConnectMode mode) {
        super(thresholder);
        this.mode = mode;
        this.algorithm = algorithm;
    }

    @Override
    public List<ConnectedComponent> segment(FImage image) {
        FImage timg = (FImage)image.process(this.thresholder);
        return this.algorithm.findComponents(timg, 0.0f, this.mode);
    }
}

