/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.feature.MultidimensionalDoubleFV;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.statistics.BlockHistogramModel;
import org.openimaj.math.statistics.distribution.MultidimensionalHistogram;

@Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh", "Yuan-Chen Ho", "Brian A. Barsky", "Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})
public class LRIntensityBalance
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    int nbins = 64;
    double balance;

    public LRIntensityBalance() {
    }

    public LRIntensityBalance(int nbins) {
        this.nbins = nbins;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.balance});
    }

    public void analyseImage(FImage image) {
        BlockHistogramModel hm = new BlockHistogramModel(2, 1, this.nbins);
        hm.estimateModel(image);
        MultidimensionalHistogram left = hm.histograms[0][0];
        MultidimensionalHistogram right = hm.histograms[0][1];
        this.balance = left.compare((MultidimensionalDoubleFV)right, DoubleFVComparison.CHI_SQUARE);
    }
}

