/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.astheticode;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.contour.Contour;
import org.openimaj.image.feature.astheticode.Aestheticode;
import org.openimaj.util.function.Function;
import org.openimaj.util.function.Predicate;

public class AestheticodeDetector
implements Function<Contour, List<Aestheticode>>,
Predicate<Contour> {
    private static final int MAX_CHILDLESS_CHILDREN_DEFAULT = 0;
    private static final int MAX_CHILDREN_DEFAULT = 5;
    private static final int MIN_CHILDREN_DEFAULT = 5;
    private int minChildren;
    private int maxChildren;
    private int maxChildlessChildren;

    public AestheticodeDetector() {
        this.minChildren = 5;
        this.maxChildren = 5;
        this.maxChildlessChildren = 0;
    }

    public AestheticodeDetector(int minChildren, int maxChildren, int maxChildless) {
        this.minChildren = minChildren;
        this.maxChildren = maxChildren;
        this.maxChildlessChildren = maxChildless;
    }

    public List<Aestheticode> apply(Contour in) {
        ArrayList<Aestheticode> found = new ArrayList<Aestheticode>();
        this.detectCode(in, found);
        return found;
    }

    private void detectCode(Contour root, List<Aestheticode> found) {
        if (this.test(root)) {
            found.add(new Aestheticode(root));
        } else {
            for (Contour child : root.children) {
                this.detectCode(child, found);
            }
        }
    }

    public boolean test(Contour in) {
        if (in.children.size() < this.minChildren || in.children.size() > this.maxChildren) {
            return false;
        }
        int childlessChild = 0;
        for (Contour child : in.children) {
            if (child.children.size() == 0) {
                ++childlessChild;
            }
            if (childlessChild > this.maxChildlessChildren) {
                return false;
            }
            for (Contour grandchildren : child.children) {
                if (grandchildren.children.size() == 0) continue;
                return false;
            }
        }
        return true;
    }
}

