/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.connectedcomponent.proc;

import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.statistics.BasicDescriptiveStatisticsModel;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.util.array.ArrayUtils;

public class ColourDescriptor
implements ConnectedComponentProcessor,
FeatureVectorProvider<DoubleFV> {
    protected MBFImage image;
    protected BasicDescriptiveStatisticsModel colmodel = new BasicDescriptiveStatisticsModel(3);

    public ColourDescriptor() {
    }

    public ColourDescriptor(MBFImage image) {
        this.image = image;
    }

    public void process(ConnectedComponent cc) {
        this.colmodel.estimateModel(cc.extractPixels1d(this.image));
    }

    public double[] getFeatureVectorArray() {
        return ArrayUtils.concatenate((double[][])new double[][]{this.colmodel.mean, this.colmodel.median, this.colmodel.mode, this.colmodel.range, this.colmodel.variance});
    }

    public void setImage(MBFImage img) {
        this.image = img;
    }

    public BasicDescriptiveStatisticsModel getModel() {
        return this.colmodel;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(this.getFeatureVectorArray());
    }

    public static enum ColourDescriptorType {
        MEAN{

            @Override
            public DoubleFV getFeatureVector(ColourDescriptor desc) {
                return new DoubleFV(desc.colmodel.mean);
            }
        }
        ,
        MODE{

            @Override
            public DoubleFV getFeatureVector(ColourDescriptor desc) {
                return new DoubleFV(desc.colmodel.mode);
            }
        }
        ,
        MEDIAN{

            @Override
            public DoubleFV getFeatureVector(ColourDescriptor desc) {
                return new DoubleFV(desc.colmodel.median);
            }
        }
        ,
        RANGE{

            @Override
            public DoubleFV getFeatureVector(ColourDescriptor desc) {
                return new DoubleFV(desc.colmodel.range);
            }
        }
        ,
        VARIANCE{

            @Override
            public DoubleFV getFeatureVector(ColourDescriptor desc) {
                return new DoubleFV(desc.colmodel.variance);
            }
        };


        public abstract DoubleFV getFeatureVector(ColourDescriptor var1);
    }
}

